/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.shell.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.api.core.Traverser;
import org.neo4j.impl.shell.NeoApp;
import org.neo4j.util.shell.AbstractApp;
import org.neo4j.util.shell.AppCommandParser;
import org.neo4j.util.shell.OptionValueType;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trav
extends NeoApp {
    public Trav() {
        this.addValueType("o", new AbstractApp.OptionContext(OptionValueType.MUST, "The traversal order [BREADTH_FIRST/DEPTH_FIRST/breadth/depth]"));
        this.addValueType("r", new AbstractApp.OptionContext(OptionValueType.MUST, "The relationship type(s) expressed as a JSON string (supports regex\nmatching of the types) f.ex. \"MY_REL_TYPE:out,.*_HAS_.*:both\".\nMatching is case-insensitive."));
        this.addValueType("f", new AbstractApp.OptionContext(OptionValueType.MUST, "Filters node property keys/values. Supplied either as a single value\nor as a JSON string where both keys and values can contain regex.\nStarting/ending {} brackets are optional. Examples:\n\"username\"\n   nodes which has property 'username' gets listed\n\".*name: ma.*, age: ''\"\n   nodes which has any key matching '.*name' where the property value\n   for that key matches 'ma.*' AND has the 'age' property gets listed"));
        this.addValueType("i", new AbstractApp.OptionContext(OptionValueType.NONE, "Filters are case-insensitive (case-sensitive by default)"));
        this.addValueType("l", new AbstractApp.OptionContext(OptionValueType.NONE, "Filters matches more loosely, i.e. it's considered a match if just\na part of a value matches the pattern, not necessarily the whole value"));
        this.addValueType("c", new AbstractApp.OptionContext(OptionValueType.MUST, "Command to run for each returned node. Use $n as a node-id replacement.\nExample: -c \"ls -f name $n\". Multiple commands can be supplied with\n&& in between"));
    }

    public String getDescription() {
        return "Traverses the node space from your current position (pwd). It's a reflection\nof the neo4j traverser API with some options for filtering which nodes\nwill be returned.";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        this.assertCurrentIsNode(session);
        Node node = this.getCurrent(session).asNode();
        Object[] relationshipTypes = this.parseRelationshipTypes(parser, out);
        if (relationshipTypes.length == 0) {
            out.println((Serializable)((Object)"No matching relationship types"));
            return null;
        }
        StopEvaluator stopEvaluator = this.parseStopEvaluator(parser);
        ReturnableEvaluator returnableEvaluator = this.parseReturnableEvaluator(parser);
        Traverser.Order order = this.parseOrder(parser);
        String filterString = (String)parser.options().get("f");
        Map filterMap = filterString != null ? Trav.parseFilter((String)filterString, (Output)out) : null;
        boolean caseInsensitiveFilters = parser.options().containsKey("i");
        boolean looseFilters = parser.options().containsKey("l");
        String commandToRun = (String)parser.options().get("c");
        String[] commandsToRun = commandToRun != null ? commandToRun.split(Pattern.quote("&&")) : new String[]{};
        for (Node traversedNode : node.traverse(order, stopEvaluator, returnableEvaluator, relationshipTypes)) {
            boolean hit = false;
            if (filterMap == null) {
                hit = true;
            } else {
                HashMap<String, Boolean> matchPerFilterKey = new HashMap<String, Boolean>();
                for (String key : traversedNode.getPropertyKeys()) {
                    for (Map.Entry filterEntry : filterMap.entrySet()) {
                        String filterKey = (String)filterEntry.getKey();
                        if (matchPerFilterKey.containsKey(filterKey) || !Trav.matches(Trav.newPattern(filterKey, caseInsensitiveFilters), key, caseInsensitiveFilters, looseFilters)) continue;
                        Object value = traversedNode.getProperty(key);
                        String filterPattern = filterEntry.getValue() != null ? filterEntry.getValue().toString() : null;
                        if (!Trav.matches(Trav.newPattern(filterPattern, caseInsensitiveFilters), value.toString(), caseInsensitiveFilters, looseFilters)) continue;
                        matchPerFilterKey.put(filterKey, true);
                    }
                }
                if (matchPerFilterKey.size() == filterMap.size()) {
                    hit = true;
                }
            }
            if (!hit) continue;
            out.println((Serializable)((Object)Trav.getDisplayName(this.getNeoServer(), session, traversedNode)));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("n", traversedNode.getId());
            for (String command : commandsToRun) {
                String line = this.templateString(command, "\\$", data);
                this.getServer().interpretLine(line, session, out);
            }
            out.println();
        }
        return null;
    }

    private String templateString(String templateString, String variablePrefix, Map<String, Object> data) {
        HashMap lengthMap = new HashMap();
        int longest = 0;
        for (String key : data.keySet()) {
            int length = key.length();
            if (length > longest) {
                longest = length;
            }
            List<String> innerList = null;
            Integer innerKey = length;
            if (lengthMap.containsKey(innerKey)) {
                innerList = (List)lengthMap.get(innerKey);
            } else {
                innerList = new ArrayList();
                lengthMap.put(innerKey, innerList);
            }
            innerList.add(key);
        }
        String result = templateString;
        for (int i = longest; i >= 0; --i) {
            Integer lengthKey = i;
            if (!lengthMap.containsKey(lengthKey)) continue;
            List list = (List)lengthMap.get(lengthKey);
            for (String key : list) {
                String replacement = data.get(key).toString();
                String regExpMatchString = variablePrefix + key;
                result = result.replaceAll(regExpMatchString, replacement);
            }
        }
        return result;
    }

    private Traverser.Order parseOrder(AppCommandParser parser) {
        return (Traverser.Order)Trav.parseEnum(Traverser.Order.class, (String)parser.options().get("o"), Traverser.Order.DEPTH_FIRST);
    }

    private ReturnableEvaluator parseReturnableEvaluator(AppCommandParser parser) {
        return ReturnableEvaluator.ALL_BUT_START_NODE;
    }

    private StopEvaluator parseStopEvaluator(AppCommandParser parser) {
        return StopEvaluator.END_OF_GRAPH;
    }

    private Object[] parseRelationshipTypes(AppCommandParser parser, Output out) throws ShellException, RemoteException {
        String option = (String)parser.options().get("r");
        ArrayList<Object> result = new ArrayList<Object>();
        if (option == null) {
            for (RelationshipType type : this.getNeoServer().getNeo().getRelationshipTypes()) {
                result.add(type);
                result.add((Object)Direction.BOTH);
            }
        } else {
            Map map = Trav.parseFilter((String)option, (Output)out);
            ArrayList<RelationshipType> allRelationshipTypes = new ArrayList<RelationshipType>();
            for (RelationshipType relationshipType : this.getNeoServer().getNeo().getRelationshipTypes()) {
                allRelationshipTypes.add(relationshipType);
            }
            for (Map.Entry entry : map.entrySet()) {
                String type = (String)entry.getKey();
                Direction direction = this.getDirection((String)entry.getValue(), Direction.BOTH);
                Pattern typePattern = Pattern.compile(type);
                for (RelationshipType relationshipType : allRelationshipTypes) {
                    if (!relationshipType.name().equals(type) && !Trav.matches(typePattern, relationshipType.name(), true, false)) continue;
                    result.add(relationshipType);
                    result.add((Object)direction);
                }
            }
        }
        return result.toArray();
    }
}

