/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.api.core.EmbeddedNeo;
import org.neo4j.api.core.NeoService;

public class SpringTransactionManager
implements TransactionManager {
    private TransactionManager tm;

    public SpringTransactionManager() {
    }

    public SpringTransactionManager(NeoService neo) {
        this.tm = ((EmbeddedNeo)neo).getConfig().getTxModule().getTxManager();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.tm.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.tm.commit();
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.tm.getTransaction();
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.tm.resume(tx);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int sec) throws SystemException {
        this.tm.setTransactionTimeout(sec);
    }

    public Transaction suspend() throws SystemException {
        return this.tm.suspend();
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }
}

