/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.transaction;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.neo4j.impl.transaction.TxManager;
import org.neo4j.impl.transaction.XaDataSourceManager;
import org.neo4j.impl.transaction.xaframework.XaDataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxModule {
    private static final String MODULE_NAME = "TxModule";
    private boolean startIsOk = true;
    private String dataSourceConfigFile = null;
    private String txLogDir = "var/tm";
    private final TxManager txManager;
    private final XaDataSourceManager xaDsManager;

    public TxModule(String txLogDir) {
        this.txLogDir = txLogDir;
        this.txManager = new TxManager(txLogDir);
        this.xaDsManager = new XaDataSourceManager();
    }

    public void init() {
    }

    public void start() {
        if (!this.startIsOk) {
            return;
        }
        if (this.dataSourceConfigFile != null) {
            new XaDataSourceConfigFileParser().parse(this.dataSourceConfigFile);
        }
        this.txManager.init(this.xaDsManager);
        this.startIsOk = false;
    }

    public void setXaDataSourceConfig(String fileName) {
        this.dataSourceConfigFile = fileName;
    }

    public String getXaDataSourceConfig() {
        return this.dataSourceConfigFile;
    }

    public void reload() {
        this.stop();
        this.start();
    }

    public void stop() {
        this.xaDsManager.unregisterAllDataSources();
        this.txManager.stop();
    }

    public void destroy() {
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public XaDataSource registerDataSource(String dsName, String className, byte[] resourceId, Map<?, ?> params) {
        XaDataSourceManager xaDsMgr = this.xaDsManager;
        String name = dsName.toLowerCase();
        if (xaDsMgr.hasDataSource(name)) {
            throw new RuntimeException("Data source[" + name + "] has already been registered");
        }
        try {
            XaDataSource dataSource = xaDsMgr.create(className, params);
            xaDsMgr.registerDataSource(name, dataSource, resourceId);
            return dataSource;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create data source [" + name + "], see nested exception for cause of error", e);
        }
    }

    public XaDataSource registerDataSource(String dsName, String className, byte[] resourceId, Map<?, ?> params, boolean useExisting) {
        XaDataSourceManager xaDsMgr = this.xaDsManager;
        String name = dsName.toLowerCase();
        if (xaDsMgr.hasDataSource(name)) {
            if (useExisting) {
                return xaDsMgr.getXaDataSource(name);
            }
            throw new RuntimeException("Data source[" + name + "] has already been registered");
        }
        try {
            XaDataSource dataSource = xaDsMgr.create(className, params);
            xaDsMgr.registerDataSource(name, dataSource, resourceId);
            return dataSource;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create data source " + name + "[" + name + "]", e);
        }
    }

    public String getTxLogDirectory() {
        return this.txLogDir;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public XaDataSourceManager getXaDataSourceManager() {
        return this.xaDsManager;
    }

    private class XaDataSourceConfigFileParser {
        private XaDataSourceConfigFileParser() {
        }

        void parse(String file) {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(file);
                Element root = (Element)document.getElementsByTagName("datasources").item(0);
                NodeList list = root.getElementsByTagName("xadatasource");
                for (int i = 0; i < list.getLength(); ++i) {
                    this.parseXaDataSourceElement((Element)list.item(i));
                }
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Error parsing " + file, e);
            }
            catch (SAXException e) {
                throw new RuntimeException("Error parsing " + file, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error parsing " + file, e);
            }
        }

        private void parseXaDataSourceElement(Element element) {
            XaDataSourceManager xaDsMgr = TxModule.this.xaDsManager;
            NamedNodeMap attributes = element.getAttributes();
            String name = attributes.getNamedItem("name").getNodeValue();
            if (xaDsMgr.hasDataSource(name = name.toLowerCase())) {
                throw new RuntimeException("Data source[" + name + "] has already been registered");
            }
            String fqn = attributes.getNamedItem("class").getNodeValue();
            String branchId = attributes.getNamedItem("branchid").getNodeValue();
            if (!branchId.startsWith("0x")) {
                throw new RuntimeException("Unable to parse branch id[" + branchId + "] on " + name + "[" + fqn + "], branch id should start with \"0x\"" + " since they are hexadecimal");
            }
            if (branchId.length() != 8) {
                throw new RuntimeException("Unable to parse branch id[" + branchId + "] on " + name + "[" + fqn + "], branch id must be a 3 byte hexadecimal number");
            }
            byte[] resourceId = this.getBranchId(branchId.substring(2, branchId.length()));
            HashMap<String, String> params = new HashMap<String, String>();
            NodeList list = element.getElementsByTagName("param");
            for (int i = 0; i < list.getLength(); ++i) {
                Element param = (Element)list.item(i);
                attributes = param.getAttributes();
                String key = attributes.getNamedItem("name").getNodeValue();
                String value = attributes.getNamedItem("value").getNodeValue();
                params.put(key, value);
            }
            try {
                XaDataSource dataSource = xaDsMgr.create(fqn, params);
                xaDsMgr.registerDataSource(name, dataSource, resourceId);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create data source " + name + "[" + fqn + "]", e);
            }
        }

        private byte[] getBranchId(String branchId) {
            byte[] resourceId = branchId.getBytes();
            return resourceId;
        }
    }
}

