/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.IndexService;
import org.neo4j.index.Isolation;
import org.neo4j.index.impl.IndexServiceQueue;

public abstract class GenericIndexService
implements IndexService {
    private final GraphDatabaseService graphDb;
    private final IndexServiceQueue queue;
    private ThreadLocal<Isolation> threadIsolation = new ThreadLocal<Isolation>(){

        @Override
        protected Isolation initialValue() {
            return Isolation.SAME_TX;
        }
    };

    protected abstract void removeIndexThisTx(Node var1, String var2, Object var3);

    protected abstract void indexThisTx(Node var1, String var2, Object var3);

    public GenericIndexService(GraphDatabaseService graphDb) {
        if (graphDb == null) {
            throw new IllegalArgumentException("Null graph database service");
        }
        this.graphDb = graphDb;
        this.queue = new IndexServiceQueue(this);
        this.queue.start();
    }

    public void index(Node node, String key, Object value) {
        Isolation level = this.threadIsolation.get();
        if (level == Isolation.SAME_TX) {
            this.indexThisTx(node, key, value);
        } else {
            this.queue.queueIndex(level, node, key, value);
        }
    }

    public void removeIndex(Node node, String key, Object value) {
        Isolation level = this.threadIsolation.get();
        if (level == Isolation.SAME_TX) {
            this.removeIndexThisTx(node, key, value);
        } else {
            this.queue.queueRemove(level, node, key, value);
        }
    }

    protected GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    public void setIsolation(Isolation level) {
        this.threadIsolation.set(level);
    }

    protected Transaction beginTx() {
        return this.graphDb.beginTx();
    }

    public void shutdown() {
        this.queue.stopRunning();
    }

    protected IndexServiceQueue getQueue() {
        return this.queue;
    }
}

