/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.btree;

import javax.transaction.Transaction;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.index.impl.btree.BTree;
import org.neo4j.index.impl.btree.KeyEntry;
import org.neo4j.kernel.EmbeddedGraphDatabase;

class TreeNode {
    private BTree bTree;
    private Node treeNode;

    TreeNode(BTree bTree, Node underlyingNode) {
        this.bTree = bTree;
        this.treeNode = underlyingNode;
    }

    Node getUnderlyingNode() {
        return this.treeNode;
    }

    TreeNode getParent() {
        Relationship toParentNode = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (toParentNode != null) {
            Node parentNode = toParentNode.getStartNode();
            Relationship prevEntry = parentNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
            while (prevEntry != null) {
                parentNode = prevEntry.getStartNode();
                prevEntry = parentNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
            }
            return new TreeNode(this.bTree, parentNode);
        }
        return null;
    }

    private Node disconnectFromParent() {
        Relationship toParentNode = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING);
        Node parentNode = toParentNode.getStartNode();
        toParentNode.delete();
        return parentNode;
    }

    private void connectToParent(Node parent) {
        assert (this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING) == null);
        parent.createRelationshipTo(this.treeNode, (RelationshipType)BTree.RelTypes.SUB_TREE);
    }

    void delete() {
        KeyEntry entry;
        if (!this.isRoot()) {
            this.disconnectFromParent();
        }
        if ((entry = this.getFirstEntry()) == null) {
            this.getUnderlyingNode().delete();
            return;
        }
        TreeNode subTree = entry.getBeforeSubTree();
        if (subTree != null) {
            subTree.delete();
        }
        Node lastNode = null;
        while (entry != null) {
            subTree = entry.getAfterSubTree();
            if (subTree != null) {
                subTree.delete();
            }
            KeyEntry nextEntry = entry.getNextKey();
            lastNode = entry.getEndNode();
            entry.getStartNode().delete();
            entry.getUnderlyingRelationship().delete();
            entry = nextEntry;
        }
        if (lastNode != null) {
            lastNode.delete();
        }
    }

    int delete(int commitInterval, int count) {
        KeyEntry entry;
        if (!this.isRoot()) {
            this.disconnectFromParent();
            ++count;
        }
        if ((entry = this.getFirstEntry()) == null) {
            this.getUnderlyingNode().delete();
            return count++;
        }
        TreeNode subTree = entry.getBeforeSubTree();
        if (subTree != null) {
            subTree.delete(commitInterval, count);
        }
        Node lastNode = null;
        while (entry != null) {
            subTree = entry.getAfterSubTree();
            if (subTree != null) {
                subTree.delete(commitInterval, count);
            }
            KeyEntry nextEntry = entry.getNextKey();
            lastNode = entry.getEndNode();
            entry.getStartNode().delete();
            entry.getUnderlyingRelationship().delete();
            ++count;
            entry = nextEntry;
        }
        if (lastNode != null) {
            lastNode.delete();
            ++count;
        }
        if (count >= commitInterval) {
            EmbeddedGraphDatabase graphDb = (EmbeddedGraphDatabase)this.bTree.getGraphDb();
            try {
                Transaction tx = graphDb.getConfig().getTxModule().getTxManager().getTransaction();
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            graphDb.beginTx();
            count = 0;
        }
        return count;
    }

    KeyEntry getFirstEntry() {
        Relationship keyEntryRel = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        assert (this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING) == null);
        if (keyEntryRel != null) {
            return new KeyEntry(this, keyEntryRel);
        }
        return null;
    }

    KeyEntry getLastEntry() {
        Relationship keyEntryRel = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        KeyEntry last = null;
        while (keyEntryRel != null) {
            last = new KeyEntry(this, keyEntryRel);
            keyEntryRel = keyEntryRel.getEndNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        }
        return last;
    }

    private int getEntryCount() {
        int entryCount = 0;
        for (KeyEntry entry = this.getFirstEntry(); entry != null; entry = entry.getNextKey()) {
            ++entryCount;
        }
        return entryCount;
    }

    KeyEntry addEntry(long key, Object value) {
        return this.addEntry(key, value, false);
    }

    KeyEntry addEntry(long key, Object value, boolean ignoreIfExist) {
        int entryCount = 0;
        for (KeyEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            long currentKey = keyEntry.getKey();
            if (currentKey == key) {
                if (ignoreIfExist) {
                    return null;
                }
                throw new RuntimeException("Key already exist:" + key);
            }
            ++entryCount;
            if (key < currentKey) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.addEntry(key, value, ignoreIfExist);
                }
                for (KeyEntry entry = keyEntry.getNextKey(); entry != null; entry = entry.getNextKey()) {
                    ++entryCount;
                }
                Node blankNode = this.bTree.getGraphDb().createNode();
                KeyEntry createdEntry = this.createEntry(keyEntry.getStartNode(), blankNode, key, value, null);
                keyEntry.move(this, blankNode, keyEntry.getEndNode());
                assert (++entryCount <= this.bTree.getOrder());
                if (this.bTree.getOrder() == entryCount) {
                    this.moveMiddleUp();
                    return this.bTree.getAsKeyEntry(key);
                }
                return createdEntry;
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.addEntry(key, value, ignoreIfExist);
            }
            Node blankNode = this.bTree.getGraphDb().createNode();
            KeyEntry createdEntry = this.createEntry(keyEntry.getEndNode(), blankNode, key, value, null);
            assert (++entryCount <= this.bTree.getOrder());
            if (this.bTree.getOrder() == entryCount) {
                this.moveMiddleUp();
                return this.bTree.getAsKeyEntry(key);
            }
            return createdEntry;
        }
        assert (this.isRoot());
        assert (!this.treeNode.getRelationships(new RelationshipType[]{BTree.RelTypes.SUB_TREE}).iterator().hasNext());
        Node blankNode = this.bTree.getGraphDb().createNode();
        return this.createEntry(this.treeNode, blankNode, key, value, null);
    }

    private KeyEntry createEntry(Node startNode, Node endNode, long key, Object value, Object keyValue) {
        KeyEntry newEntry = new KeyEntry(this, startNode.createRelationshipTo(endNode, (RelationshipType)BTree.RelTypes.KEY_ENTRY));
        newEntry.setKey(key);
        newEntry.setValue(value);
        if (keyValue != null) {
            newEntry.setKeyValue(keyValue);
        }
        return newEntry;
    }

    boolean isRoot() {
        return this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.TREE_ROOT, Direction.INCOMING) != null;
    }

    private KeyEntry insertEntry(long key, Object value, Object keyValue) {
        for (KeyEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            long currentKey = keyEntry.getKey();
            assert (currentKey != key);
            if (key < currentKey) {
                Node blankNode = this.bTree.getGraphDb().createNode();
                KeyEntry newEntry = this.createEntry(keyEntry.getStartNode(), blankNode, key, value, keyValue);
                keyEntry.move(this, blankNode, keyEntry.getEndNode());
                return newEntry;
            }
            if (keyEntry.getNextKey() != null) continue;
            Node blankNode = this.bTree.getGraphDb().createNode();
            return this.createEntry(keyEntry.getEndNode(), blankNode, key, value, keyValue);
        }
        Node blankNode = this.bTree.getGraphDb().createNode();
        return this.createEntry(this.treeNode, blankNode, key, value, keyValue);
    }

    private void moveMiddleUp() {
        TreeNode parent = this.getParent();
        if (parent == null) {
            assert (this.isRoot());
            parent = new TreeNode(this.bTree, this.bTree.getGraphDb().createNode());
            this.bTree.makeRoot(parent);
        } else {
            this.disconnectFromParent();
        }
        KeyEntry middleEntry = this.getFirstEntry();
        for (int i = 0; i < this.bTree.getOrder() / 2; ++i) {
            middleEntry = middleEntry.getNextKey();
        }
        TreeNode newTreeToTheRight = new TreeNode(this.bTree, middleEntry.getEndNode());
        KeyEntry movedMiddleEntry = parent.insertEntry(middleEntry.getKey(), middleEntry.getValue(), middleEntry.getKeyValue());
        middleEntry.getUnderlyingRelationship().delete();
        movedMiddleEntry.getStartNode().createRelationshipTo(this.getUnderlyingNode(), (RelationshipType)BTree.RelTypes.SUB_TREE);
        movedMiddleEntry.getEndNode().createRelationshipTo(newTreeToTheRight.getUnderlyingNode(), (RelationshipType)BTree.RelTypes.SUB_TREE);
        int parentEntryCount = parent.getEntryCount();
        if (parentEntryCount == this.bTree.getOrder()) {
            parent.moveMiddleUp();
        }
        assert (parent.getEntryCount() <= this.bTree.getOrder());
    }

    KeyEntry getEntry(long key) {
        for (KeyEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            long currentKey = keyEntry.getKey();
            if (currentKey == key) {
                return keyEntry;
            }
            if (key < currentKey) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.getEntry(key);
                }
                return null;
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.getEntry(key);
            }
            return null;
        }
        return null;
    }

    KeyEntry getClosestLowerEntry(KeyEntry prevEntry, long key) {
        for (KeyEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            long currentKey = keyEntry.getKey();
            if (currentKey == key) {
                return keyEntry;
            }
            if (key < currentKey) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.getClosestLowerEntry(prevEntry, key);
                }
                return prevEntry;
            }
            if (keyEntry.getNextKey() == null) {
                TreeNode subTree = keyEntry.getAfterSubTree();
                if (subTree != null) {
                    return subTree.getClosestLowerEntry(keyEntry, key);
                }
                return keyEntry;
            }
            prevEntry = keyEntry;
        }
        return prevEntry;
    }

    KeyEntry getClosestHigherEntry(KeyEntry nextEntry, long key) {
        for (KeyEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            long currentKey = keyEntry.getKey();
            if (currentKey == key) {
                return keyEntry;
            }
            if (key < currentKey) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.getClosestHigherEntry(keyEntry, key);
                }
                return keyEntry;
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.getClosestHigherEntry(nextEntry, key);
            }
            return nextEntry;
        }
        return nextEntry;
    }

    public Object removeEntry(long key) {
        KeyEntry entry = null;
        KeyEntry keyEntry = this.getFirstEntry();
        if (keyEntry == null) {
            return null;
        }
        int entryCount = 0;
        while (keyEntry != null) {
            ++entryCount;
            long currentKey = keyEntry.getKey();
            if (currentKey == key) {
                entry = keyEntry;
                for (keyEntry = keyEntry.getNextKey(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
                    ++entryCount;
                }
                break;
            }
            if (key < currentKey) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.removeEntry(key);
                }
                return null;
            }
            if (keyEntry.getNextKey() == null) {
                TreeNode subTree = keyEntry.getAfterSubTree();
                if (subTree != null) {
                    return subTree.removeEntry(key);
                }
                return null;
            }
            keyEntry = keyEntry.getNextKey();
        }
        assert (entry != null);
        if (entry.isLeaf()) {
            KeyEntry nextEntry = entry.getNextKey();
            if (nextEntry != null) {
                nextEntry.move(this, entry.getStartNode(), nextEntry.getEndNode());
            }
            Object value = entry.getValue();
            entry.getEndNode().delete();
            entry.getUnderlyingRelationship().delete();
            if (--entryCount < this.bTree.getOrder() / 2 && !this.isRoot()) {
                this.tryBorrowFromSibling();
            }
            return value;
        }
        KeyEntry successor = entry.getAfterSubTree().getFirstEntry();
        while (!successor.isLeaf()) {
            successor = successor.getBeforeSubTree().getFirstEntry();
        }
        TreeNode leafTree = successor.getTreeNode();
        KeyEntry next = successor.getNextKey();
        next.move(leafTree, successor.getStartNode(), next.getEndNode());
        successor.move(this, entry.getStartNode(), entry.getEndNode());
        Object value = entry.getValue();
        entry.getUnderlyingRelationship().delete();
        entryCount = leafTree.getEntryCount();
        if (entryCount < this.bTree.getOrder() / 2 && !leafTree.isRoot()) {
            leafTree.tryBorrowFromSibling();
        }
        return value;
    }

    private void tryBorrowFromSibling() {
        TreeNode leftSibling = this.getLeftSibbling();
        TreeNode rightSibling = this.getRightSibbling();
        if (leftSibling != null && leftSibling.getEntryCount() > this.bTree.getOrder() / 2) {
            this.borrowFromLeftSibling(leftSibling);
        } else if (rightSibling != null && rightSibling.getEntryCount() > this.bTree.getOrder() / 2) {
            this.borrowFromRightSibling(rightSibling);
        } else if (leftSibling != null) {
            this.mergeWithLeftSibling(leftSibling);
        } else if (rightSibling != null) {
            this.mergeWithRightSibling(rightSibling);
        } else {
            throw new RuntimeException();
        }
    }

    private void borrowFromLeftSibling(TreeNode leftSibling) {
        TreeNode parentNode = this.getParent();
        KeyEntry entryToMoveDown = new KeyEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING));
        KeyEntry entryToMoveUp = leftSibling.getLastEntry();
        TreeNode subTree = entryToMoveUp.getAfterSubTree();
        if (subTree != null) {
            subTree.disconnectFromParent();
        }
        entryToMoveUp.getEndNode().delete();
        entryToMoveUp.move(parentNode, entryToMoveDown.getStartNode(), entryToMoveDown.getEndNode());
        Node newStartNode = this.bTree.getGraphDb().createNode();
        entryToMoveDown.move(this, newStartNode, this.treeNode);
        Node parentToReAttachTo = this.disconnectFromParent();
        this.treeNode = newStartNode;
        this.connectToParent(parentToReAttachTo);
        if (subTree != null) {
            subTree.connectToParent(newStartNode);
        }
    }

    private void borrowFromRightSibling(TreeNode rightSibling) {
        TreeNode parentNode = this.getParent();
        KeyEntry entryToMoveDown = new KeyEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING));
        KeyEntry entryToMoveUp = rightSibling.getFirstEntry();
        TreeNode subTree = entryToMoveUp.getBeforeSubTree();
        if (subTree != null) {
            subTree.disconnectFromParent();
        }
        Node rightParentToReAttachTo = rightSibling.disconnectFromParent();
        rightSibling.treeNode = entryToMoveUp.getEndNode();
        rightSibling.connectToParent(rightParentToReAttachTo);
        entryToMoveUp.getStartNode().delete();
        entryToMoveUp.move(parentNode, entryToMoveDown.getStartNode(), entryToMoveDown.getEndNode());
        Node newLastNode = this.bTree.getGraphDb().createNode();
        entryToMoveDown.move(this, this.getLastEntry().getEndNode(), newLastNode);
        if (subTree != null) {
            subTree.connectToParent(newLastNode);
        }
    }

    private void mergeWithLeftSibling(TreeNode leftSibling) {
        int entryCount;
        KeyEntry entry;
        TreeNode subTree;
        TreeNode parentNode = this.getParent();
        KeyEntry entryToMoveDown = new KeyEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING));
        KeyEntry nextParentEntry = entryToMoveDown.getNextKey();
        if (nextParentEntry != null) {
            nextParentEntry.move(parentNode, entryToMoveDown.getStartNode(), nextParentEntry.getEndNode());
        }
        if ((subTree = (entry = this.getFirstEntry()).getBeforeSubTree()) != null) {
            subTree.disconnectFromParent();
        }
        this.disconnectFromParent();
        entryToMoveDown.getEndNode().delete();
        Node blankNode = this.bTree.getGraphDb().createNode();
        entryToMoveDown.move(leftSibling, leftSibling.getLastEntry().getEndNode(), blankNode);
        entry.getStartNode().delete();
        entry.move(leftSibling, blankNode, entry.getEndNode());
        this.treeNode = leftSibling.treeNode;
        if (subTree != null) {
            subTree.connectToParent(blankNode);
        }
        if ((entryCount = parentNode.getEntryCount()) < this.bTree.getOrder() / 2 && !parentNode.isRoot()) {
            assert (entryCount > 0);
            parentNode.tryBorrowFromSibling();
        } else if (entryCount == 0) {
            assert (parentNode.isRoot());
            this.disconnectFromParent();
            this.bTree.makeRoot(this);
        }
    }

    private void mergeWithRightSibling(TreeNode rightSibling) {
        int entryCount;
        KeyEntry entry;
        TreeNode subTree;
        TreeNode parentNode = this.getParent();
        KeyEntry entryToMoveDown = new KeyEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING));
        KeyEntry nextInParent = entryToMoveDown.getNextKey();
        if (nextInParent != null) {
            nextInParent.move(parentNode, entryToMoveDown.getStartNode(), nextInParent.getEndNode());
        }
        if ((subTree = (entry = rightSibling.getFirstEntry()).getBeforeSubTree()) != null) {
            subTree.disconnectFromParent();
        }
        rightSibling.disconnectFromParent();
        entryToMoveDown.getEndNode().delete();
        Node blankNode = this.bTree.getGraphDb().createNode();
        entryToMoveDown.move(this, this.getLastEntry().getEndNode(), blankNode);
        entry.getStartNode().delete();
        entry.move(this, blankNode, entry.getEndNode());
        rightSibling.treeNode = this.treeNode;
        if (subTree != null) {
            subTree.connectToParent(blankNode);
        }
        if ((entryCount = parentNode.getEntryCount()) < this.bTree.getOrder() / 2 && !parentNode.isRoot()) {
            assert (entryCount > 0);
            parentNode.tryBorrowFromSibling();
        } else if (entryCount == 0) {
            assert (parentNode.isRoot());
            this.disconnectFromParent();
            this.bTree.makeRoot(this);
        }
    }

    TreeNode getLeftSibbling() {
        Relationship parent = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (parent == null) {
            return null;
        }
        Relationship prevEntry = parent.getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
        if (prevEntry == null) {
            return null;
        }
        return new TreeNode(this.getBTree(), prevEntry.getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING).getEndNode());
    }

    TreeNode getRightSibbling() {
        Relationship parent = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (parent == null) {
            return null;
        }
        Relationship nextEntry = parent.getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        if (nextEntry == null) {
            return null;
        }
        return new TreeNode(this.getBTree(), nextEntry.getEndNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING).getEndNode());
    }

    BTree getBTree() {
        return this.bTree;
    }
}

