/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.sortedtree;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.index.impl.btree.BTree;
import org.neo4j.index.impl.sortedtree.SortedTree;
import org.neo4j.index.impl.sortedtree.TreeNode;

class NodeEntry {
    static final String NODE_ID = "node_id";
    private Relationship entryRelationship;
    private TreeNode treeNode;

    NodeEntry(TreeNode treeNode, Relationship underlyingRelationship) {
        assert (treeNode != null);
        assert (underlyingRelationship != null);
        this.treeNode = treeNode;
        this.entryRelationship = underlyingRelationship;
    }

    Relationship getUnderlyingRelationship() {
        return this.entryRelationship;
    }

    TreeNode getTreeNode() {
        return this.treeNode;
    }

    private SortedTree getBTree() {
        return this.treeNode.getBTree();
    }

    TreeNode getBeforeSubTree() {
        Relationship subTreeRel = this.getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING);
        if (subTreeRel != null) {
            return new TreeNode(this.getBTree(), subTreeRel.getEndNode());
        }
        return null;
    }

    TreeNode getAfterSubTree() {
        Relationship subTreeRel = this.getEndNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING);
        if (subTreeRel != null) {
            return new TreeNode(this.getBTree(), subTreeRel.getEndNode());
        }
        return null;
    }

    NodeEntry getNextKey() {
        Relationship nextKeyRel = this.getEndNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        if (nextKeyRel != null) {
            return new NodeEntry(this.getTreeNode(), nextKeyRel);
        }
        return null;
    }

    NodeEntry getPreviousKey() {
        Relationship prevKeyRel = this.getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
        if (prevKeyRel != null) {
            return new NodeEntry(this.getTreeNode(), prevKeyRel);
        }
        return null;
    }

    public void remove() {
        this.treeNode.removeEntry(this.getTheNode());
    }

    public String toString() {
        return "Entry[" + this.getTheNode() + "]";
    }

    boolean isLeaf() {
        if (this.getUnderlyingRelationship().getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING) != null) {
            assert (this.getUnderlyingRelationship().getEndNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING) != null);
            return false;
        }
        assert (this.getUnderlyingRelationship().getEndNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING) == null);
        return true;
    }

    Node getTheNode() {
        return this.getBTree().getGraphDb().getNodeById(((Long)this.getUnderlyingRelationship().getProperty(NODE_ID)).longValue());
    }

    void setTheNode(Node node) {
        this.getUnderlyingRelationship().setProperty(NODE_ID, (Object)node.getId());
    }

    Node getStartNode() {
        return this.entryRelationship.getStartNode();
    }

    Node getEndNode() {
        return this.entryRelationship.getEndNode();
    }

    void move(TreeNode node, Node startNode, Node endNode) {
        assert (node != null);
        this.treeNode = node;
        Node theNode = this.getTheNode();
        this.entryRelationship.delete();
        this.entryRelationship = startNode.createRelationshipTo(endNode, (RelationshipType)BTree.RelTypes.KEY_ENTRY);
        this.setTheNode(theNode);
    }
}

