/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.neo4j.index.lucene.IndexSearcherRef;
import org.neo4j.index.lucene.LuceneCommand;
import org.neo4j.index.lucene.LuceneIndexService;
import org.neo4j.index.lucene.LuceneIndexStore;
import org.neo4j.index.lucene.LuceneTransaction;
import org.neo4j.index.lucene.LuceneXaConnection;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneDataSource
extends XaDataSource {
    public static final Analyzer LOWER_CASE_WHITESPACE_ANALYZER = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new LowerCaseFilter((TokenStream)new WhitespaceTokenizer(reader));
        }
    };
    private final ArrayMap<String, IndexSearcherRef> indexSearchers = new ArrayMap(6, true, true);
    private final XaContainer xaContainer;
    private final String storeDir;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Analyzer fieldAnalyzer;
    private final LuceneIndexStore store;
    private LuceneIndexService indexService;
    private Map<String, LruCache<String, Collection<Long>>> caching = Collections.synchronizedMap(new HashMap());

    public LuceneDataSource(Map<Object, Object> params) throws InstantiationException {
        super(params);
        this.storeDir = (String)params.get("dir");
        this.fieldAnalyzer = this.instantiateAnalyzer();
        String dir = this.storeDir;
        File file = new File(dir);
        if (!file.exists()) {
            try {
                this.autoCreatePath(dir);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create directory " + dir, e);
            }
        }
        this.store = new LuceneIndexStore(this.storeDir + "/lucene-store.db");
        LuceneCommandFactory cf = new LuceneCommandFactory();
        LuceneTransactionFactory tf = new LuceneTransactionFactory(this.store);
        this.xaContainer = XaContainer.create((String)(dir + "/lucene.log"), (XaCommandFactory)cf, (XaTransactionFactory)tf, params);
        try {
            this.xaContainer.openLogicalLog();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open lucene log in " + dir, e);
        }
    }

    protected void setIndexService(LuceneIndexService indexService) {
        this.indexService = indexService;
    }

    public LuceneIndexService getIndexService() {
        return this.indexService;
    }

    private Analyzer instantiateAnalyzer() {
        return LOWER_CASE_WHITESPACE_ANALYZER;
    }

    private void autoCreatePath(String dirs) throws IOException {
        File directories = new File(dirs);
        if (!directories.exists() && !directories.mkdirs()) {
            throw new IOException("Unable to create directory path[" + dirs + "] for Neo4j store.");
        }
    }

    public void close() {
        for (IndexSearcherRef searcher : this.indexSearchers.values()) {
            try {
                searcher.dispose();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.indexSearchers.clear();
        this.xaContainer.close();
        this.store.close();
    }

    public XaConnection getXaConnection() {
        return new LuceneXaConnection(this.storeDir, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    protected Analyzer getAnalyzer() {
        return this.fieldAnalyzer;
    }

    void getReadLock() {
        this.lock.readLock().lock();
    }

    void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    void getWriteLock() {
        this.lock.writeLock().lock();
    }

    void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    private IndexSearcherRef refreshSearcher(IndexSearcherRef searcher) {
        try {
            IndexReader reader = searcher.getSearcher().getIndexReader();
            IndexReader reopened = reader.reopen();
            if (reopened != reader) {
                IndexSearcher newSearcher = new IndexSearcher(reopened);
                searcher.detachOrClose();
                return new IndexSearcherRef(searcher.getKey(), newSearcher);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Directory getDirectory(String key) throws IOException {
        return FSDirectory.open((File)new File(this.storeDir, key));
    }

    IndexSearcherRef getIndexSearcher(String key) {
        try {
            IndexSearcherRef searcher = (IndexSearcherRef)this.indexSearchers.get((Object)key);
            if (searcher == null) {
                Directory dir = this.getDirectory(key);
                try {
                    String[] files = dir.listAll();
                    if (files == null || files.length == 0) {
                        return null;
                    }
                }
                catch (IOException e) {
                    return null;
                }
                IndexReader indexReader = IndexReader.open((Directory)dir, (boolean)false);
                IndexSearcher indexSearcher = new IndexSearcher(indexReader);
                searcher = new IndexSearcherRef(key, indexSearcher);
                this.indexSearchers.put((Object)key, (Object)searcher);
            }
            return searcher;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    XaTransaction createTransaction(int identifier, XaLogicalLog logicalLog) {
        return new LuceneTransaction(identifier, logicalLog, this);
    }

    void invalidateIndexSearcher(String key) {
        IndexSearcherRef refreshedSearcher;
        IndexSearcherRef searcher = (IndexSearcherRef)this.indexSearchers.get((Object)key);
        if (searcher != null && (refreshedSearcher = this.refreshSearcher(searcher)) != null) {
            this.indexSearchers.put((Object)key, (Object)refreshedSearcher);
        }
    }

    synchronized IndexWriter getIndexWriter(String key) {
        try {
            Directory dir = this.getDirectory(key);
            IndexWriter writer = new IndexWriter(dir, this.getAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
            return writer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void deleteDocumentsUsingWriter(IndexWriter writer, Long nodeId, Object value) {
        try {
            if (nodeId == null && value == null) {
                writer.deleteAll();
            } else {
                BooleanQuery query = new BooleanQuery();
                if (value != null) {
                    query.add((Query)new TermQuery(new Term(this.getDeleteDocumentsKey(), value.toString())), BooleanClause.Occur.MUST);
                }
                query.add((Query)new TermQuery(new Term("id", "" + nodeId)), BooleanClause.Occur.MUST);
                writer.deleteDocuments((Query)query);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete for " + nodeId + "," + "," + value + " using" + writer, e);
        }
    }

    protected String getDeleteDocumentsKey() {
        return "index";
    }

    void removeWriter(String key, IndexWriter writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close lucene writer " + writer, e);
        }
    }

    LruCache<String, Collection<Long>> getFromCache(String key) {
        return this.caching.get(key);
    }

    void enableCache(String key, int maxNumberOfCachedEntries) {
        this.caching.put(key, (LruCache<String, Collection<Long>>)new LruCache(key, maxNumberOfCachedEntries, null));
    }

    Integer getEnabledCacheSize(String key) {
        LruCache<String, Collection<Long>> cache = this.caching.get(key);
        return cache != null ? Integer.valueOf(cache.maxSize()) : null;
    }

    void invalidateCache(String key, Object value) {
        LruCache<String, Collection<Long>> cache = this.caching.get(key);
        if (cache != null) {
            cache.remove((Object)value.toString());
        }
    }

    void invalidateCache(String key) {
        this.caching.remove(key);
    }

    void invalidateCache() {
        this.caching.clear();
    }

    protected void fillDocument(Document document, long nodeId, String key, Object value) {
        document.add((Fieldable)new Field("id", String.valueOf(nodeId), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field("index", value.toString(), Field.Store.NO, this.getIndexStrategy(key, value)));
    }

    protected Field.Index getIndexStrategy(String key, Object value) {
        return Field.Index.NOT_ANALYZED;
    }

    public void keepLogicalLogs(boolean keep) {
        this.xaContainer.getLogicalLog().setKeepLogs(keep);
    }

    public long getCreationTime() {
        return this.store.getCreationTime();
    }

    public long getRandomIdentifier() {
        return this.store.getRandomNumber();
    }

    public long getCurrentLogVersion() {
        return this.store.getVersion();
    }

    public void applyLog(ReadableByteChannel byteChannel) throws IOException {
        this.xaContainer.getLogicalLog().applyLog(byteChannel);
    }

    public void rotateLogicalLog() throws IOException {
        this.xaContainer.getLogicalLog().rotate();
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.xaContainer.getLogicalLog().getLogicalLog(version);
    }

    public boolean hasLogicalLog(long version) {
        return this.xaContainer.getLogicalLog().hasLogicalLog(version);
    }

    public boolean deleteLogicalLog(long version) {
        return this.xaContainer.getLogicalLog().deleteLogicalLog(version);
    }

    public void setAutoRotate(boolean rotate) {
        this.xaContainer.getLogicalLog().setAutoRotateLogs(rotate);
    }

    public void setLogicalLogTargetSize(long size) {
        this.xaContainer.getLogicalLog().setLogicalLogTargetSize(size);
    }

    public void makeBackupSlave() {
        this.xaContainer.getLogicalLog().makeBackupSlave();
    }

    public String getFileName(long version) {
        return this.xaContainer.getLogicalLog().getFileName(version);
    }

    public long getLogicalLogLength(long version) {
        return this.xaContainer.getLogicalLog().getLogicalLogLength(version);
    }

    private class LuceneTransactionFactory
    extends XaTransactionFactory {
        private final LuceneIndexStore store;

        LuceneTransactionFactory(LuceneIndexStore store) {
            this.store = store;
        }

        public XaTransaction create(int identifier) {
            return LuceneDataSource.this.createTransaction(identifier, this.getLogicalLog());
        }

        public void flushAll() {
        }

        public long getCurrentVersion() {
            return this.store.getVersion();
        }

        public long getAndSetNewVersion() {
            return this.store.incrementVersion();
        }
    }

    private class LuceneCommandFactory
    extends XaCommandFactory {
        LuceneCommandFactory() {
        }

        public XaCommand readCommand(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
            return LuceneCommand.readCommand(channel, buffer);
        }
    }
}

