/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.neo4j.index.lucene.LuceneDataSource;
import org.neo4j.index.lucene.LuceneFulltextTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFulltextDataSource
extends LuceneDataSource {
    public LuceneFulltextDataSource(Map<Object, Object> params) throws InstantiationException {
        super(params);
    }

    @Override
    public XaTransaction createTransaction(int identifier, XaLogicalLog logicalLog) {
        return new LuceneFulltextTransaction(identifier, logicalLog, this);
    }

    @Override
    protected Field.Index getIndexStrategy(String key, Object value) {
        return Field.Index.ANALYZED;
    }

    @Override
    protected String getDeleteDocumentsKey() {
        return "index_source";
    }

    @Override
    protected void fillDocument(Document document, long nodeId, String key, Object value) {
        super.fillDocument(document, nodeId, key, value);
        document.add((Fieldable)new Field("index_source", value.toString(), Field.Store.NO, Field.Index.NOT_ANALYZED));
    }
}

