/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.index.IndexHits;
import org.neo4j.index.lucene.LuceneDataSource;
import org.neo4j.index.lucene.LuceneFulltextIndexService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFulltextQueryIndexService
extends LuceneFulltextIndexService {
    public LuceneFulltextQueryIndexService(GraphDatabaseService graphDb) {
        super(graphDb);
    }

    @Override
    protected Query formQuery(String key, Object value, Object matching) {
        if (matching == LuceneFulltextIndexService.MatchingType.EXACT) {
            return super.formQuery(key, value, matching);
        }
        try {
            QueryParser parser = new QueryParser(Version.LUCENE_CURRENT, "index", LuceneDataSource.LOWER_CASE_WHITESPACE_ANALYZER);
            QueryParser.Operator operator = this.getDefaultQueryOperator(key, value);
            if (operator != null) {
                parser.setDefaultOperator(operator);
            }
            return parser.parse(value.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public QueryParser.Operator getDefaultQueryOperator(String key, Object value) {
        return null;
    }

    @Override
    public IndexHits<Node> getNodes(String key, Object value) {
        return super.getNodes(key, value);
    }
}

