/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.neo4j.graphdb.Node;
import org.neo4j.index.lucene.LuceneCommand;
import org.neo4j.index.lucene.LuceneDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneTransaction
extends XaTransaction {
    private final Map<String, TxCache> txIndexed = new HashMap<String, TxCache>();
    private final Map<String, TxCache> txRemoved = new HashMap<String, TxCache>();
    private final LuceneDataSource luceneDs;
    private final Map<String, List<LuceneCommand>> commandMap = new HashMap<String, List<LuceneCommand>>();

    LuceneTransaction(int identifier, XaLogicalLog xaLog, LuceneDataSource luceneDs) {
        super(identifier, xaLog);
        this.luceneDs = luceneDs;
    }

    void index(Node node, String key, Object value) {
        this.insert(node, key, value, this.txRemoved, this.txIndexed);
        this.queueCommand(new LuceneCommand.AddCommand(node.getId(), key, value.toString()));
    }

    void removeIndex(Node node, String key, Object value) {
        this.insert(node, key, value, this.txIndexed, this.txRemoved);
        this.queueCommand(new LuceneCommand.RemoveCommand(node != null ? Long.valueOf(node.getId()) : null, key, value != null ? value.toString() : null));
    }

    private void queueCommand(LuceneCommand command) {
        String key = command.getKey();
        List<LuceneCommand> commands = this.commandMap.get(key);
        if (commands == null) {
            commands = new ArrayList<LuceneCommand>();
            this.commandMap.put(key, commands);
        }
        commands.add(command);
    }

    private void insert(Node node, String key, Object value, Map<String, TxCache> toRemoveFrom, Map<String, TxCache> toInsertInto) {
        this.delFromIndex(node, key, value, toRemoveFrom);
        TxCache keyIndex = toInsertInto.get(key);
        if (keyIndex == null) {
            keyIndex = new TxCache();
            toInsertInto.put(key, keyIndex);
        }
        keyIndex.add(node != null ? Long.valueOf(node.getId()) : null, value);
    }

    private boolean delFromIndex(Node node, String key, Object value, Map<String, TxCache> map) {
        TxCache keyIndex = map.get(key);
        if (keyIndex == null) {
            return false;
        }
        boolean modified = false;
        if (node != null) {
            Long nodeId = node.getId();
            if (value != null) {
                keyIndex.remove(nodeId, value);
            } else {
                keyIndex.remove(nodeId);
            }
        } else {
            keyIndex.remove();
        }
        return modified;
    }

    Set<Long> getDeletedNodesFor(String key, Object value, Object matching) {
        TxCache keyIndex = this.txRemoved.get(key);
        LazyMergedSet result = null;
        if (keyIndex != null) {
            result = new LazyMergedSet();
            result.add((Set)keyIndex.map.get(value));
            result.add((Set)keyIndex.map.get(null));
        }
        return result != null && result.get() != null ? result.get() : Collections.emptySet();
    }

    boolean getIndexDeleted(String key) {
        TxCache keyIndex = this.txRemoved.get(key);
        return keyIndex != null ? keyIndex.all : false;
    }

    Set<Long> getNodesFor(String key, Object value, Object matching) {
        Set nodeIds;
        TxCache keyIndex = this.txIndexed.get(key);
        if (keyIndex != null && (nodeIds = (Set)keyIndex.map.get(value)) != null) {
            return nodeIds;
        }
        return Collections.emptySet();
    }

    protected LuceneDataSource getDataSource() {
        return this.luceneDs;
    }

    private void indexWriter(IndexWriter writer, long nodeId, String key, Object value) {
        Document document = new Document();
        this.luceneDs.fillDocument(document, nodeId, key, value);
        try {
            writer.addDocument(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doAddCommand(XaCommand command) {
    }

    protected void injectCommand(XaCommand command) {
        this.queueCommand((LuceneCommand)command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() {
        this.luceneDs.getWriteLock();
        try {
            for (Map.Entry<String, List<LuceneCommand>> entry : this.commandMap.entrySet()) {
                String key = entry.getKey();
                IndexWriter writer = this.luceneDs.getIndexWriter(key);
                for (LuceneCommand command : entry.getValue()) {
                    Long nodeId = command.getNodeId();
                    String value = command.getValue();
                    if (command instanceof LuceneCommand.AddCommand) {
                        this.indexWriter(writer, nodeId, key, value);
                    } else if (command instanceof LuceneCommand.RemoveCommand) {
                        this.luceneDs.deleteDocumentsUsingWriter(writer, nodeId, value);
                    } else {
                        throw new RuntimeException("Unknown command type " + (Object)((Object)command) + ", " + ((Object)((Object)command)).getClass());
                    }
                    if (value != null) {
                        this.luceneDs.invalidateCache(key, value);
                        continue;
                    }
                    this.luceneDs.invalidateCache(key);
                }
                this.luceneDs.removeWriter(key, writer);
                this.luceneDs.invalidateIndexSearcher(key);
            }
        }
        finally {
            this.luceneDs.releaseWriteLock();
        }
    }

    protected void doPrepare() {
        for (Map.Entry<String, List<LuceneCommand>> entry : this.commandMap.entrySet()) {
            for (LuceneCommand command : entry.getValue()) {
                this.addCommand(command);
            }
        }
    }

    protected void doRollback() {
        this.commandMap.clear();
        this.txIndexed.clear();
        this.txRemoved.clear();
    }

    public boolean isReadOnly() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TxCache {
        private final Map<Object, Set<Long>> map = new HashMap<Object, Set<Long>>();
        private final Map<Long, Set<Object>> reverseMap = new HashMap<Long, Set<Object>>();
        boolean all;

        private TxCache() {
        }

        void add(Long nodeId, Object value) {
            if (nodeId == null && value == null) {
                this.all = true;
                return;
            }
            Set<Long> ids = this.map.get(value);
            if (ids == null) {
                ids = new HashSet<Long>();
                this.map.put(value, ids);
            }
            ids.add(nodeId);
            Set<Object> values = this.reverseMap.get(nodeId);
            if (values == null) {
                values = new HashSet<Object>();
                this.reverseMap.put(nodeId, values);
            }
            values.add(value);
        }

        void remove(Long nodeId, Object value) {
            Set<Object> values;
            Set<Long> ids = this.map.get(value);
            if (ids != null) {
                ids.remove(nodeId);
            }
            if ((values = this.reverseMap.get(nodeId)) != null) {
                values.remove(value);
            }
        }

        void remove(Long nodeId) {
            Set<Object> values = this.reverseMap.get(nodeId);
            if (values == null) {
                return;
            }
            for (Object value : values.toArray()) {
                Set<Long> ids = this.map.get(value);
                if (ids != null) {
                    ids.remove(nodeId);
                }
                this.reverseMap.remove(value);
            }
        }

        void remove() {
            this.map.clear();
            this.reverseMap.clear();
        }

        Iterable<Long> getNodesForValue(Object value) {
            return this.map.get(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LazyMergedSet<T> {
        private Set<T> set;
        private int count;

        LazyMergedSet() {
        }

        private void add(Set<T> setOrNull) {
            if (setOrNull == null) {
                return;
            }
            if (this.count == 0) {
                this.set = setOrNull;
            } else {
                if (this.count == 1) {
                    this.set = new HashSet<T>(this.set);
                }
                this.set.addAll(setOrNull);
            }
            ++this.count;
        }

        private Set<T> get() {
            return this.set;
        }
    }
}

