/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.graphdb.Node;
import org.neo4j.index.lucene.LuceneTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnectionHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;

public class LuceneXaConnection
extends XaConnectionHelpImpl {
    private final LuceneXaResource xaResource;
    private LuceneTransaction luceneTx;

    LuceneXaConnection(Object identifier, XaResourceManager xaRm, byte[] branchId) {
        super(xaRm);
        this.xaResource = new LuceneXaResource(identifier, xaRm, branchId);
    }

    public XAResource getXaResource() {
        return this.xaResource;
    }

    LuceneTransaction getLuceneTx() {
        if (this.luceneTx == null) {
            try {
                this.luceneTx = (LuceneTransaction)this.getTransaction();
            }
            catch (XAException e) {
                throw new RuntimeException("Unable to get lucene tx", e);
            }
        }
        return this.luceneTx;
    }

    void index(Node node, String key, Object value) {
        this.getLuceneTx().index(node, key, value);
    }

    void removeIndex(Node node, String key, Object value) {
        this.getLuceneTx().removeIndex(node, key, value);
    }

    private static class LuceneXaResource
    extends XaResourceHelpImpl {
        private final Object identifier;

        LuceneXaResource(Object identifier, XaResourceManager xaRm, byte[] branchId) {
            super(xaRm, branchId);
            this.identifier = identifier;
        }

        public boolean isSameRM(XAResource xares) {
            if (xares instanceof LuceneXaResource) {
                return this.identifier.equals(((LuceneXaResource)((Object)xares)).identifier);
            }
            return false;
        }
    }
}

