/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.Map;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.StartLocalClient;
import org.neo4j.shell.StartRemoteClient;
import org.neo4j.shell.impl.AbstractStarter;

public class StartClient
extends AbstractStarter {
    public static void main(String[] args) {
        Map<String, String> argMap = StartClient.parseArgs(args);
        if (argMap.containsKey("?") || argMap.containsKey("h") || argMap.containsKey("help") || argMap.containsKey("usage")) {
            StartClient.printUsage();
            return;
        }
        String path = argMap.get("path");
        String port = argMap.get("port");
        String name = argMap.get("name");
        if (path != null && (port != null || name != null)) {
            System.err.println("You have supplied both path as well as port/name. You should either supply only path or port/name so that either a local or remote shell client can be started");
            return;
        }
        if (path != null) {
            try {
                StartClient.checkNeo4jDependency();
            }
            catch (ShellException e) {
                StartClient.handleException(e, argMap);
            }
            StartLocalClient.main(args);
        } else {
            StartRemoteClient.main(args);
        }
    }

    private static void checkNeo4jDependency() throws ShellException {
        try {
            Class.forName("org.neo4j.graphdb.GraphDatabaseService");
        }
        catch (Exception e) {
            throw new ShellException("Neo4j not found on the classpath", e);
        }
    }
}

