/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.apps.extra;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptExecutor {
    protected abstract String getPathKey();

    protected String getDefaultPaths() {
        return ".:src:src" + File.separator + "script";
    }

    public void execute(String line, Session session, Output out) throws ShellException {
        this.ensureDependenciesAreInClasspath();
        if (line == null || line.trim().length() == 0) {
            return;
        }
        List<String> pathList = this.getEnvPaths(session);
        String[] paths = pathList.toArray(new String[pathList.size()]);
        Object interpreter = this.newInterpreter(paths);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("out", out);
        properties.put("session", session);
        this.runScripts(interpreter, properties, line, paths);
    }

    private void runScripts(Object interpreter, Map<String, Object> properties, String line, String[] paths) throws ShellException {
        ArgReader reader = new ArgReader(AppCommandParser.tokenizeStringWithQuotes(line));
        while (reader.hasNext()) {
            String arg = reader.next();
            if (!arg.startsWith("--")) continue;
            String[] scriptArgs = this.getScriptArgs(reader);
            String scriptName = arg.substring(2);
            HashMap<String, Object> props = new HashMap<String, Object>(properties);
            props.put("args", scriptArgs);
            this.runScript(interpreter, scriptName, props, paths);
        }
    }

    protected abstract void runScript(Object var1, String var2, Map<String, Object> var3, String[] var4) throws ShellException;

    protected String findProperMessage(Throwable e) {
        String message = e.toString();
        if (e.getCause() != null) {
            message = this.findProperMessage(e.getCause());
        }
        return message;
    }

    protected String stackTraceAsString(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        e.printStackTrace(printer);
        printer.close();
        return writer.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getScriptArgs(ArgReader reader) {
        reader.mark();
        try {
            String arg;
            ArrayList<String> list = new ArrayList<String>();
            while (reader.hasNext() && !(arg = reader.next()).startsWith("--")) {
                list.add(arg);
                reader.mark();
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        finally {
            reader.flip();
        }
    }

    private List<String> getEnvPaths(Session session) throws ShellException {
        try {
            ArrayList<String> list = new ArrayList<String>();
            this.collectPaths(list, (String)((Object)session.get(this.getPathKey())));
            this.collectPaths(list, this.getDefaultPaths());
            return list;
        }
        catch (RemoteException e) {
            throw new ShellException(e);
        }
    }

    private void collectPaths(List<String> paths, String pathString) {
        if (pathString != null && pathString.trim().length() > 0) {
            for (String path : pathString.split(":")) {
                paths.add(path);
            }
        }
    }

    protected abstract Object newInterpreter(String[] var1) throws ShellException;

    protected abstract void ensureDependenciesAreInClasspath() throws ShellException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArgReader
    implements Iterator<String> {
        private static final int START_INDEX = -1;
        private int index = -1;
        private String[] args;
        private Integer mark;

        ArgReader(String[] args) {
            this.args = args;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.args.length;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return this.args[this.index];
        }

        public void previous() {
            --this.index;
            if (this.index < -1) {
                this.index = -1;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void mark() {
            this.mark = this.index;
        }

        public void flip() {
            if (this.mark == null) {
                throw new IllegalStateException();
            }
            this.index = this.mark;
            this.mark = null;
        }
    }
}

