/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.neo4j.shell.ShellClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractStarter {
    protected static void setSessionVariablesFromArgs(ShellClient client, String[] args) throws RemoteException {
        Map<String, String> map = AbstractStarter.parseArgs(args);
        String profile = map.get("profile");
        if (profile != null) {
            AbstractStarter.applyProfileFile(new File(profile), client);
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("D")) continue;
            key = key.substring(1);
            client.session().set(key, (Serializable)((Object)entry.getValue()));
        }
    }

    private static void applyProfileFile(File file, ShellClient client) {
        InputStream in = null;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            for (Object key : properties.keySet()) {
                String stringKey = (String)key;
                String value = properties.getProperty(stringKey);
                client.session().set(stringKey, (Serializable)((Object)value));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't find profile '" + file.getAbsolutePath() + "'");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static boolean isOption(String arg) {
        return arg.startsWith("-");
    }

    private static String stripOption(String arg) {
        while (arg.length() > 0 && arg.charAt(0) == '-') {
            arg = arg.substring(1);
        }
        return arg;
    }

    protected static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String key;
            String arg = args[i];
            if (!AbstractStarter.isOption(arg)) continue;
            int equalIndex = (arg = AbstractStarter.stripOption(arg)).indexOf(61);
            if (equalIndex != -1) {
                key = arg.substring(0, equalIndex);
                String value = arg.substring(equalIndex + 1);
                map.put(key, value);
                continue;
            }
            key = arg;
            int nextIndex = i + 1;
            String value = nextIndex < args.length ? args[nextIndex] : null;
            value = value == null || AbstractStarter.isOption(value) ? null : value;
            map.put(key, value);
        }
        return map;
    }

    protected static Boolean stringAsBoolean(String stringOrNull, Boolean defaultValue) {
        return stringOrNull != null ? new Boolean(stringOrNull) : defaultValue;
    }

    protected static void handleException(Exception e, Map<String, String> argMap) {
        String message = e.getCause() instanceof ConnectException ? "Connection refused" : e.getMessage();
        System.err.println("ERROR (-v for expanded information):\n\t" + message);
        if (argMap.containsKey("v")) {
            e.printStackTrace(System.err);
        }
        System.err.println();
        AbstractStarter.printUsage();
        System.exit(1);
    }

    protected static void printUsage() {
        int port = 1337;
        String name = "shell";
        String pathArg = "path";
        String portArg = "port";
        String nameArg = "name";
        System.out.println("Example arguments for remote:\n\t-" + portArg + " " + port + "\n" + "\t-" + portArg + " " + port + " -" + nameArg + " " + name + "\n" + "\t...or no arguments\n" + "Example arguments for local:\n" + "\t-" + pathArg + " /path/to/db" + "\n" + "\t-" + pathArg + " /path/to/db -readonly");
    }
}

