/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import jline.Completor;
import jline.SimpleCompletor;
import org.neo4j.shell.App;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.AppShellServer;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShellTabCompletor
implements Completor {
    private final ShellClient client;
    private final Completor appNameCompletor;

    public ShellTabCompletor(ShellClient client) throws RemoteException {
        this.client = client;
        this.appNameCompletor = new SimpleCompletor(client.getServer().getAllAvailableCommands());
    }

    public int complete(String buffer, int cursor, List candidates) {
        if (buffer == null || buffer.length() == 0) {
            return cursor;
        }
        try {
            if (buffer.contains(" ")) {
                AppCommandParser parser = new AppCommandParser((AppShellServer)this.client.getServer(), buffer.toString());
                App app = parser.app();
                List<String> appCandidates = app.completionCandidates(buffer, this.client.session());
                if ((appCandidates = this.quote(appCandidates)).size() == 1) {
                    appCandidates.set(0, appCandidates.get(0) + " ");
                }
                candidates.addAll(appCandidates);
                return buffer.length() - TextUtil.lastWordOrQuoteOf(buffer, true).length();
            }
            return this.appNameCompletor.complete(buffer, cursor, candidates);
        }
        catch (ShellException e) {
            e.printStackTrace();
            return cursor;
        }
    }

    private List<String> quote(List<String> candidates) {
        ArrayList<String> result = new ArrayList<String>();
        for (String candidate : candidates) {
            candidate = candidate.replaceAll(" ", "\\\\ ");
            result.add(candidate);
        }
        return result;
    }
}

