/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TextUtil;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TypedId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cd
extends GraphDatabaseApp {
    private static final String START_ALIAS = "start";
    private static final String END_ALIAS = "end";
    public static final String WORKING_DIR_KEY = "WORKING_DIR";

    public Cd() {
        this.addOptionDefinition("a", new OptionDefinition(OptionValueType.NONE, "Absolute id, new primitive doesn't need to be connected to the\ncurrent one"));
        this.addOptionDefinition("r", new OptionDefinition(OptionValueType.NONE, "Makes the supplied id represent a relationship instead of a node"));
    }

    @Override
    public String getDescription() {
        return "Changes the current node or relationship, i.e. traverses one step to another\nnode or relationship. Usage: cd <id>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> completionCandidates(String partOfLine, Session session) {
        String lastWord = TextUtil.lastWordOrQuoteOf(partOfLine, false);
        if (lastWord.startsWith("-")) {
            return super.completionCandidates(partOfLine, session);
        }
        Transaction tx = this.getServer().getDb().beginTx();
        try {
            TreeSet<String> result = new TreeSet<String>();
            NodeOrRelationship current = this.getCurrent(session);
            if (current.isNode()) {
                Node node = current.asNode();
                for (Relationship rel : node.getRelationships()) {
                    Node otherNode = rel.getOtherNode(node);
                    long otherNodeId = otherNode.getId();
                    String title = Cd.findTitle(this.getServer(), session, otherNode);
                    if (title != null && !result.contains(title)) {
                        Cd.maybeAddCompletionCandidate(result, title + "," + otherNodeId, lastWord);
                    }
                    Cd.maybeAddCompletionCandidate(result, "" + otherNodeId, lastWord);
                }
            } else {
                Cd.maybeAddCompletionCandidate(result, START_ALIAS, lastWord);
                Cd.maybeAddCompletionCandidate(result, END_ALIAS, lastWord);
                Relationship rel = current.asRelationship();
                Cd.maybeAddCompletionCandidate(result, "" + rel.getStartNode().getId(), lastWord);
                Cd.maybeAddCompletionCandidate(result, "" + rel.getEndNode().getId(), lastWord);
            }
            tx.success();
            ArrayList<String> arrayList = new ArrayList<String>(result);
            return arrayList;
        }
        catch (ShellException e) {
            e.printStackTrace();
            List<String> list = super.completionCandidates(partOfLine, session);
            return list;
        }
        finally {
            tx.finish();
        }
    }

    private static void maybeAddCompletionCandidate(Collection<String> candidates, String candidate, String lastWord) {
        if (lastWord.length() == 0 || candidate.startsWith(lastWord)) {
            candidates.add(candidate);
        }
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        List<TypedId> paths = Cd.readPaths(session);
        NodeOrRelationship current = this.getCurrent(session);
        NodeOrRelationship newThing = null;
        if (parser.arguments().isEmpty()) {
            newThing = NodeOrRelationship.wrap(this.getServer().getDb().getReferenceNode());
            paths.clear();
        } else {
            String arg = parser.arguments().get(0);
            TypedId newId = current.getTypedId();
            if (arg.equals("..")) {
                if (paths.size() > 0) {
                    newId = paths.remove(paths.size() - 1);
                }
            } else if (!arg.equals(".")) {
                if (arg.equals(START_ALIAS) || arg.equals(END_ALIAS)) {
                    newId = this.getStartOrEnd(current, arg);
                    paths.add(current.getTypedId());
                } else {
                    long suppliedId;
                    block12: {
                        suppliedId = -1L;
                        try {
                            suppliedId = Long.parseLong(arg);
                        }
                        catch (NumberFormatException e) {
                            suppliedId = this.findNodeWithTitle(current.asNode(), arg, session);
                            if (suppliedId != -1L) break block12;
                            throw new ShellException("No connected node with title '" + arg + "'");
                        }
                    }
                    TypedId typedId = newId = parser.options().containsKey("r") ? new TypedId("r", suppliedId) : new TypedId("n", suppliedId);
                    if (newId.equals(current.getTypedId())) {
                        throw new ShellException("Can't cd to where you stand");
                    }
                    boolean absolute = parser.options().containsKey("a");
                    if (!absolute && !this.isConnected(current, newId)) {
                        throw new ShellException(Cd.getDisplayName(this.getServer(), session, newId, false) + " isn't connected to the current primitive," + " use -a to force it to go there anyway");
                    }
                    paths.add(current.getTypedId());
                }
            }
            newThing = this.getThingById(newId);
        }
        Cd.setCurrent(session, newThing);
        session.set(WORKING_DIR_KEY, (Serializable)((Object)this.makePath(paths)));
        return null;
    }

    private long findNodeWithTitle(Node node, String match, Session session) {
        Object[] matchParts = this.splitNodeTitleAndId(match);
        if (matchParts[1] != null) {
            return (Long)matchParts[1];
        }
        String titleMatch = (String)matchParts[0];
        for (Relationship rel : node.getRelationships()) {
            Node otherNode = rel.getOtherNode(node);
            String title = Cd.findTitle(this.getServer(), session, otherNode);
            if (!titleMatch.equals(title)) continue;
            return otherNode.getId();
        }
        return -1L;
    }

    private Object[] splitNodeTitleAndId(String string) {
        int index = string.lastIndexOf(",");
        String title = null;
        Long id = null;
        try {
            id = Long.parseLong(string.substring(index + 1));
            title = string.substring(0, index);
        }
        catch (NumberFormatException e) {
            title = string;
        }
        return new Object[]{title, id};
    }

    private TypedId getStartOrEnd(NodeOrRelationship current, String arg) throws ShellException {
        if (!current.isRelationship()) {
            throw new ShellException("Only allowed on relationships");
        }
        Node newNode = null;
        if (arg.equals(START_ALIAS)) {
            newNode = current.asRelationship().getStartNode();
        } else if (arg.equals(END_ALIAS)) {
            newNode = current.asRelationship().getEndNode();
        } else {
            throw new ShellException("Unknown alias '" + arg + "'");
        }
        return NodeOrRelationship.wrap(newNode).getTypedId();
    }

    private boolean isConnected(NodeOrRelationship current, TypedId newId) throws ShellException {
        if (current.isNode()) {
            Node currentNode = current.asNode();
            for (Relationship rel : currentNode.getRelationships()) {
                if (!(newId.isNode() ? rel.getOtherNode(currentNode).getId() == newId.getId() : rel.getId() == newId.getId())) continue;
                return true;
            }
        } else {
            if (newId.isRelationship()) {
                return false;
            }
            Relationship relationship = current.asRelationship();
            if (relationship.getStartNode().getId() == newId.getId() || relationship.getEndNode().getId() == newId.getId()) {
                return true;
            }
        }
        return false;
    }

    public static List<TypedId> readPaths(Session session) throws RemoteException {
        ArrayList<TypedId> list = new ArrayList<TypedId>();
        String path = (String)((Object)session.get(WORKING_DIR_KEY));
        if (path != null && path.trim().length() > 0) {
            for (String typedId : path.split(",")) {
                list.add(new TypedId(typedId));
            }
        }
        return list;
    }

    private String makePath(List<TypedId> paths) {
        StringBuffer buffer = new StringBuffer();
        for (TypedId typedId : paths) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(typedId.toString());
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }
}

