/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TextUtil;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TypedId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphDatabaseApp
extends AbstractApp {
    private static final String CURRENT_KEY = "CURRENT_DIR";
    static final OptionDefinition OPTION_DEF_FOR_C = new OptionDefinition(OptionValueType.MUST, "Command to run for each returned node. Use $n as a node-id replacement.\nExample: -c \"ls -f name $n\". Multiple commands can be supplied with\n&& in between");

    public static NodeOrRelationship getCurrent(GraphDatabaseShellServer server, Session session) throws ShellException {
        String currentThing = (String)((Object)GraphDatabaseApp.safeGet(session, CURRENT_KEY));
        NodeOrRelationship result = null;
        if (currentThing == null) {
            result = NodeOrRelationship.wrap(server.getDb().getReferenceNode());
            GraphDatabaseApp.setCurrent(session, result);
        } else {
            TypedId typedId = new TypedId(currentThing);
            result = GraphDatabaseApp.getThingById(server, typedId);
        }
        return result;
    }

    protected NodeOrRelationship getCurrent(Session session) throws ShellException {
        return GraphDatabaseApp.getCurrent(this.getServer(), session);
    }

    public static boolean isCurrent(Session session, NodeOrRelationship thing) {
        String currentThing = (String)((Object)GraphDatabaseApp.safeGet(session, CURRENT_KEY));
        return currentThing != null && currentThing.equals(thing.getTypedId().toString());
    }

    protected static void setCurrent(Session session, NodeOrRelationship current) {
        GraphDatabaseApp.safeSet(session, CURRENT_KEY, (Serializable)((Object)current.getTypedId().toString()));
    }

    protected void assertCurrentIsNode(Session session) throws ShellException {
        NodeOrRelationship current = this.getCurrent(session);
        if (!current.isNode()) {
            throw new ShellException("You must stand on a node to be able to do this");
        }
    }

    @Override
    public GraphDatabaseShellServer getServer() {
        return (GraphDatabaseShellServer)super.getServer();
    }

    protected RelationshipType getRelationshipType(String name) {
        return DynamicRelationshipType.withName((String)name);
    }

    protected Direction getDirection(String direction) throws ShellException {
        return this.getDirection(direction, Direction.OUTGOING);
    }

    protected Direction getDirection(String direction, Direction defaultDirection) throws ShellException {
        return (Direction)GraphDatabaseApp.parseEnum(Direction.class, direction, defaultDirection);
    }

    protected static NodeOrRelationship getThingById(GraphDatabaseShellServer server, TypedId typedId) throws ShellException {
        NodeOrRelationship result = null;
        if (typedId.isNode()) {
            try {
                result = NodeOrRelationship.wrap(server.getDb().getNodeById(typedId.getId()));
            }
            catch (NotFoundException e) {
                throw new ShellException("Node " + typedId.getId() + " not found");
            }
        }
        try {
            result = NodeOrRelationship.wrap(server.getDb().getRelationshipById(typedId.getId()));
        }
        catch (NotFoundException e) {
            throw new ShellException("Relationship " + typedId.getId() + " not found");
        }
        return result;
    }

    protected NodeOrRelationship getThingById(TypedId typedId) throws ShellException {
        return GraphDatabaseApp.getThingById(this.getServer(), typedId);
    }

    protected Node getNodeById(long id) {
        return this.getServer().getDb().getNodeById(id);
    }

    @Override
    public final String execute(AppCommandParser parser, Session session, Output out) throws ShellException {
        Transaction tx = this.getServer().getDb().beginTx();
        try {
            String result = this.exec(parser, session, out);
            tx.success();
            String string = result;
            return string;
        }
        catch (RemoteException e) {
            throw new ShellException(e);
        }
        finally {
            tx.finish();
        }
    }

    protected String directionAlternatives() {
        return "OUTGOING, INCOMING, o, i";
    }

    protected abstract String exec(AppCommandParser var1, Session var2, Output var3) throws ShellException, RemoteException;

    private static String getDisplayNameForCurrent(GraphDatabaseShellServer server, Session session) throws ShellException {
        NodeOrRelationship current = GraphDatabaseApp.getCurrent(server, session);
        return current.isNode() ? "(me)" : "<me>";
    }

    public static String getDisplayName(GraphDatabaseShellServer server, Session session, NodeOrRelationship thing, boolean checkForMe) throws ShellException {
        if (thing.isNode()) {
            return GraphDatabaseApp.getDisplayName(server, session, thing.asNode(), checkForMe);
        }
        return GraphDatabaseApp.getDisplayName(server, session, thing.asRelationship(), true, checkForMe);
    }

    public static String getDisplayName(GraphDatabaseShellServer server, Session session, TypedId typedId, boolean checkForMe) throws ShellException {
        return GraphDatabaseApp.getDisplayName(server, session, GraphDatabaseApp.getThingById(server, typedId), checkForMe);
    }

    public static String getDisplayName(GraphDatabaseShellServer server, Session session, Node node, boolean checkForMe) throws ShellException {
        if (checkForMe && GraphDatabaseApp.isCurrent(session, NodeOrRelationship.wrap(node))) {
            return GraphDatabaseApp.getDisplayNameForCurrent(server, session);
        }
        String title = GraphDatabaseApp.findTitle(server, session, node);
        StringBuilder result = new StringBuilder("(");
        result.append(node.getId());
        result.append(title != null ? "," + title : "");
        result.append(")");
        return result.toString();
    }

    protected static String findTitle(GraphDatabaseShellServer server, Session session, Node node) {
        String keys = (String)((Object)GraphDatabaseApp.safeGet(session, "TITLE_KEYS"));
        if (keys == null) {
            return null;
        }
        String[] titleKeys = keys.split(Pattern.quote(","));
        Pattern[] patterns = new Pattern[titleKeys.length];
        for (int i = 0; i < titleKeys.length; ++i) {
            patterns[i] = Pattern.compile(titleKeys[i]);
        }
        for (Pattern pattern : patterns) {
            for (String nodeKey : node.getPropertyKeys()) {
                if (!GraphDatabaseApp.matches(pattern, nodeKey, false, false)) continue;
                return GraphDatabaseApp.trimLength(session, GraphDatabaseApp.format(node.getProperty(nodeKey), false));
            }
        }
        return null;
    }

    private static String trimLength(Session session, String string) {
        int maxLength;
        String maxLengthString = (String)((Object)GraphDatabaseApp.safeGet(session, "TITLE_MAX_LENGTH"));
        int n = maxLength = maxLengthString != null ? Integer.parseInt(maxLengthString) : Integer.MAX_VALUE;
        if (string.length() > maxLength) {
            string = string.substring(0, maxLength) + "...";
        }
        return string;
    }

    public static String getDisplayName(GraphDatabaseShellServer server, Session session, Relationship relationship, boolean verbose, boolean checkForMe) throws ShellException {
        if (checkForMe && GraphDatabaseApp.isCurrent(session, NodeOrRelationship.wrap(relationship))) {
            return GraphDatabaseApp.getDisplayNameForCurrent(server, session);
        }
        StringBuilder result = new StringBuilder("<");
        result.append(verbose ? relationship.getId() + "," : "");
        result.append(relationship.getType().name());
        result.append(">");
        return result.toString();
    }

    protected static String fixCaseSensitivity(String string, boolean caseInsensitive) {
        return caseInsensitive ? string.toLowerCase() : string;
    }

    protected static Pattern newPattern(String pattern, boolean caseInsensitive) {
        return pattern == null ? null : Pattern.compile(GraphDatabaseApp.fixCaseSensitivity(pattern, caseInsensitive));
    }

    protected static boolean matches(Pattern patternOrNull, String value, boolean caseInsensitive, boolean loose) {
        if (patternOrNull == null) {
            return true;
        }
        value = GraphDatabaseApp.fixCaseSensitivity(value, caseInsensitive);
        return loose ? patternOrNull.matcher(value).find() : patternOrNull.matcher(value).matches();
    }

    protected static <T extends Enum<T>> Enum<T> parseEnum(Class<T> enumClass, String name, Enum<T> defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        name = name.toLowerCase();
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.name().equalsIgnoreCase(name)) continue;
            return enumConstant;
        }
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.name().toLowerCase().startsWith(name)) continue;
            return enumConstant;
        }
        throw new IllegalArgumentException("No '" + name + "' or '" + name + ".*' in " + enumClass);
    }

    protected static String frame(String string, boolean frame) {
        return frame ? "[" + string + "]" : string;
    }

    protected static String format(Object value, boolean includeFraming) {
        String result = null;
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object singleValue = Array.get(value, i);
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(GraphDatabaseApp.frame(singleValue.toString(), includeFraming));
            }
            result = buffer.toString();
        } else {
            result = GraphDatabaseApp.frame(value.toString(), includeFraming);
        }
        return result;
    }

    protected static void printAndInterpretTemplateLines(Collection<String> templateLines, boolean forcePrintHitHeader, boolean newLineBetweenHits, Node node, GraphDatabaseShellServer server, Session session, Output out) throws ShellException, RemoteException {
        if (templateLines.isEmpty() || forcePrintHitHeader) {
            out.println((Serializable)((Object)GraphDatabaseApp.getDisplayName(server, session, node, true)));
        }
        if (!templateLines.isEmpty()) {
            HashMap<String, Long> data = new HashMap<String, Long>();
            data.put("n", node.getId());
            for (String command : templateLines) {
                String line = TextUtil.templateString(command, data);
                server.interpretLine(line, session, out);
            }
        }
        if (newLineBetweenHits) {
            out.println();
        }
    }
}

