/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.util.ArrayList;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rmrel
extends GraphDatabaseApp {
    public Rmrel() {
        this.addOptionDefinition("d", new OptionDefinition(OptionValueType.NONE, "Must be supplied if the affected other node gets decoupled\nafter this operation so that it gets deleted."));
    }

    @Override
    public String getDescription() {
        return "Deletes a relationship\nUsage: rmrel <relationship id>";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException {
        this.assertCurrentIsNode(session);
        if (parser.arguments().isEmpty()) {
            throw new ShellException("Must supply relationship id to delete as the first argument");
        }
        Node currentNode = this.getCurrent(session).asNode();
        Relationship rel = this.findRel(currentNode, Long.parseLong(parser.arguments().get(0)));
        rel.delete();
        if (!currentNode.equals(this.getServer().getDb().getReferenceNode()) && !currentNode.getRelationships().iterator().hasNext()) {
            throw new ShellException("It would result in the current node " + currentNode + " to be decoupled (no relationships left)");
        }
        Node otherNode = rel.getOtherNode(currentNode);
        if (!otherNode.getRelationships().iterator().hasNext()) {
            boolean deleteOtherNodeWhenEmpty = parser.options().containsKey("d");
            if (!deleteOtherNodeWhenEmpty) {
                throw new ShellException("Since the node " + Rmrel.getDisplayName(this.getServer(), session, otherNode, false) + " would be decoupled after this, you must supply the" + " -d (for delete-when-decoupled) so that the other node " + "(" + otherNode + ") may be deleted");
            }
            otherNode.delete();
        } else {
            if (!this.hasPathToRefNode(otherNode)) {
                throw new ShellException("It would result in " + otherNode + " to be recursively decoupled with the reference node");
            }
            if (!this.hasPathToRefNode(currentNode)) {
                throw new ShellException("It would result in " + currentNode + " to be recursively decoupled with the reference node");
            }
        }
        return null;
    }

    private Relationship findRel(Node currentNode, long relId) throws ShellException {
        for (Relationship rel : currentNode.getRelationships()) {
            if (rel.getId() != relId) continue;
            return rel;
        }
        throw new ShellException("No relationship " + relId + " connected to " + currentNode);
    }

    private Iterable<RelationshipType> getAllRelationshipTypes() {
        return this.getServer().getDb().getRelationshipTypes();
    }

    private boolean hasPathToRefNode(Node node) {
        ArrayList<Object> filterList = new ArrayList<Object>();
        for (RelationshipType rel : this.getAllRelationshipTypes()) {
            filterList.add(rel);
            filterList.add(Direction.BOTH);
        }
        Node refNode = this.getServer().getDb().getReferenceNode();
        Traverser traverser = node.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL, filterList.toArray());
        for (Node testNode : traverser) {
            if (!refNode.equals(testNode)) continue;
            return true;
        }
        return false;
    }
}

