/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;

public class Trav
extends GraphDatabaseApp {
    public Trav() {
        this.addOptionDefinition("o", new OptionDefinition(OptionValueType.MUST, "The traversal order [BREADTH_FIRST/DEPTH_FIRST/breadth/depth]"));
        this.addOptionDefinition("r", new OptionDefinition(OptionValueType.MUST, "The relationship type(s) expressed as a JSON string (supports regex\nmatching of the types) f.ex. \"MY_REL_TYPE:out,.*_HAS_.*:both\".\nMatching is case-insensitive."));
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.MUST, "Filters node property keys/values. Supplied either as a single value\nor as a JSON string where both keys and values can contain regex.\nStarting/ending {} brackets are optional. Examples:\n\"username\"\n   nodes which has property 'username' gets listed\n\".*name: ma.*, age: ''\"\n   nodes which has any key matching '.*name' where the property value\n   for that key matches 'ma.*' AND has the 'age' property gets listed"));
        this.addOptionDefinition("i", new OptionDefinition(OptionValueType.NONE, "Filters are case-insensitive (case-sensitive by default)"));
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.NONE, "Filters matches more loosely, i.e. it's considered a match if just\na part of a value matches the pattern, not necessarily the whole value"));
        this.addOptionDefinition("c", OPTION_DEF_FOR_C);
    }

    public String getDescription() {
        return "Traverses the node space from your current position (pwd). It's a reflection\nof the neo4j traverser API with some options for filtering which nodes\nwill be returned.";
    }

    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        this.assertCurrentIsNode(session);
        Node node = this.getCurrent(session).asNode();
        boolean caseInsensitiveFilters = parser.options().containsKey("i");
        boolean looseFilters = parser.options().containsKey("l");
        Object[] relationshipTypes = this.parseRelationshipTypes(parser, out, caseInsensitiveFilters, looseFilters);
        if (relationshipTypes.length == 0) {
            out.println((Serializable)((Object)"No matching relationship types"));
            return null;
        }
        StopEvaluator stopEvaluator = this.parseStopEvaluator(parser);
        ReturnableEvaluator returnableEvaluator = this.parseReturnableEvaluator(parser);
        Traverser.Order order = this.parseOrder(parser);
        String filterString = parser.options().get("f");
        Map<String, Object> filterMap = filterString != null ? Trav.parseFilter(filterString, out) : null;
        String commandToRun = parser.options().get("c");
        ArrayList<String> commandsToRun = new ArrayList<String>();
        if (commandToRun != null) {
            commandsToRun.addAll(Arrays.asList(commandToRun.split(Pattern.quote("&&"))));
        }
        for (Node traversedNode : node.traverse(order, stopEvaluator, returnableEvaluator, relationshipTypes)) {
            boolean hit = false;
            if (filterMap == null) {
                hit = true;
            } else {
                HashMap<String, Boolean> matchPerFilterKey = new HashMap<String, Boolean>();
                for (String key : traversedNode.getPropertyKeys()) {
                    for (Map.Entry<String, Object> filterEntry : filterMap.entrySet()) {
                        String filterKey = filterEntry.getKey();
                        if (matchPerFilterKey.containsKey(filterKey) || !Trav.matches(Trav.newPattern(filterKey, caseInsensitiveFilters), key, caseInsensitiveFilters, looseFilters)) continue;
                        Object value = traversedNode.getProperty(key);
                        String filterPattern = filterEntry.getValue() != null ? filterEntry.getValue().toString() : null;
                        if (!Trav.matches(Trav.newPattern(filterPattern, caseInsensitiveFilters), value.toString(), caseInsensitiveFilters, looseFilters)) continue;
                        matchPerFilterKey.put(filterKey, true);
                    }
                }
                if (matchPerFilterKey.size() == filterMap.size()) {
                    hit = true;
                }
            }
            if (!hit) continue;
            Trav.printAndInterpretTemplateLines(commandsToRun, false, true, traversedNode, this.getServer(), session, out);
        }
        return null;
    }

    private Traverser.Order parseOrder(AppCommandParser parser) {
        return (Traverser.Order)Trav.parseEnum(Traverser.Order.class, parser.options().get("o"), Traverser.Order.DEPTH_FIRST);
    }

    private ReturnableEvaluator parseReturnableEvaluator(AppCommandParser parser) {
        return ReturnableEvaluator.ALL_BUT_START_NODE;
    }

    private StopEvaluator parseStopEvaluator(AppCommandParser parser) {
        return StopEvaluator.END_OF_GRAPH;
    }

    private Object[] parseRelationshipTypes(AppCommandParser parser, Output out, boolean caseInsensitiveFilters, boolean looseFilters) throws ShellException, RemoteException {
        String option = parser.options().get("r");
        ArrayList<Object> result = new ArrayList<Object>();
        if (option == null) {
            for (RelationshipType type : this.getServer().getDb().getRelationshipTypes()) {
                result.add(type);
                result.add(Direction.BOTH);
            }
        } else {
            Map<String, Object> map = Trav.parseFilter(option, out);
            ArrayList<RelationshipType> allRelationshipTypes = new ArrayList<RelationshipType>();
            for (RelationshipType relationshipType : this.getServer().getDb().getRelationshipTypes()) {
                allRelationshipTypes.add(relationshipType);
            }
            for (Map.Entry entry : map.entrySet()) {
                String type = (String)entry.getKey();
                Direction direction = this.getDirection((String)entry.getValue(), Direction.BOTH);
                Pattern typePattern = Trav.newPattern(type, caseInsensitiveFilters);
                for (RelationshipType relationshipType : allRelationshipTypes) {
                    if (!relationshipType.name().equals(type) && !Trav.matches(typePattern, relationshipType.name(), caseInsensitiveFilters, looseFilters)) continue;
                    result.add(relationshipType);
                    result.add(direction);
                }
            }
        }
        return result.toArray();
    }
}

