/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell;

import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.util.shell.AbstractServer;
import org.neo4j.util.shell.App;
import org.neo4j.util.shell.AppCommandParser;
import org.neo4j.util.shell.AppShellServer;
import org.neo4j.util.shell.ClassLister;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAppServer
extends AbstractServer
implements AppShellServer {
    private Set<String> packages = new HashSet<String>();

    public void addPackage(String pkg) {
        this.packages.add(pkg);
    }

    public Set<String> getPackages() {
        return new HashSet<String>(this.packages);
    }

    @Override
    public App findApp(String command) {
        for (String pkg : this.packages) {
            String name = pkg + "." + command.substring(0, 1).toUpperCase() + command.substring(1, command.length()).toLowerCase();
            try {
                Class<?> cls = Class.forName(name);
                if (cls.isInterface() || !App.class.isAssignableFrom(cls) || Modifier.isAbstract(cls.getModifiers())) continue;
                App theApp = (App)cls.newInstance();
                theApp.setServer(this);
                return theApp;
            }
            catch (Exception e) {
            }
            catch (NoClassDefFoundError e) {
            }
        }
        return null;
    }

    @Override
    public String interpretLine(String line, Session session, Output out) throws ShellException {
        if (line == null || line.trim().length() == 0) {
            return "";
        }
        AppCommandParser parser = new AppCommandParser(this, line);
        return parser.app().execute(parser, session, out);
    }

    @Override
    public Iterable<String> getAllAvailableCommands() {
        return this.findAllApps();
    }

    protected Set<String> findAllApps() {
        Collection<Class<App>> apps = ClassLister.listClassesExtendingOrImplementing(App.class, this.packages);
        TreeSet<String> set = new TreeSet<String>();
        for (Class<App> app : apps) {
            set.add(app.getSimpleName().toLowerCase());
        }
        return set;
    }
}

