/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.util.shell.Console;
import org.neo4j.util.shell.JLineConsole;
import org.neo4j.util.shell.ShellClient;
import org.neo4j.util.shell.StandardConsole;

public abstract class AbstractClient
implements ShellClient {
    public static final String PROMPT_KEY = "PS1";
    public static final String STACKTRACES_KEY = "STACKTRACES";
    public static final String TITLE_KEYS_KEY = "TITLE_KEYS";
    public static final String TITLE_MAX_LENGTH = "TITLE_MAX_LENGTH";
    private static final Set<String> EXIT_COMMANDS = new HashSet<String>(Arrays.asList("exit", "quit"));
    private Console console;

    public void grabPrompt() {
        this.init();
        while (true) {
            try {
                String result;
                String line;
                do {
                    this.console.format(this.tryGetProperPromptString(), new Object[0]);
                } while (!EXIT_COMMANDS.contains(line = this.readLine()) && ((result = this.getServer().interpretLine(line, this.session(), this.getOutput())) == null || result.trim().length() == 0 || !result.contains("e")));
            }
            catch (Exception e) {
                if (this.shouldPrintStackTraces()) {
                    e.printStackTrace();
                }
                this.console.format(e.getMessage() + "\n", new Object[0]);
                continue;
            }
            break;
        }
        this.shutdown();
    }

    protected String tryGetProperPromptString() {
        String result = null;
        try {
            result = (String)((Object)this.getSessionVariable(PROMPT_KEY, null, true));
        }
        catch (Exception e) {
            result = (String)((Object)this.getSessionVariable(PROMPT_KEY, null, false));
        }
        return result;
    }

    protected void shutdown() {
    }

    private boolean shouldPrintStackTraces() {
        try {
            Serializable value = this.session().get(STACKTRACES_KEY);
            return this.getSafeBooleanValue(value, false);
        }
        catch (RemoteException e) {
            return true;
        }
    }

    private boolean getSafeBooleanValue(Object value, boolean def) {
        if (value == null) {
            return def;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private void init() {
        try {
            this.possiblyGrabDefaultVariableFromServer(PROMPT_KEY, (Serializable)((Object)"$ "));
            this.possiblyGrabDefaultVariableFromServer(TITLE_KEYS_KEY, null);
            this.possiblyGrabDefaultVariableFromServer(TITLE_MAX_LENGTH, null);
            this.getOutput().println((Serializable)((Object)this.getServer().welcome()));
            this.console = JLineConsole.newConsoleOrNullIfNotFound(this);
            if (this.console == null) {
                System.out.println("Want bash-like features? throw in jLine on the classpath");
                this.console = new StandardConsole();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected void possiblyGrabDefaultVariableFromServer(String key, Serializable defaultValue) {
        try {
            if (this.session().get(key) == null) {
                Serializable value = this.getServer().getProperty(key);
                if (value == null) {
                    value = defaultValue;
                }
                if (value != null) {
                    this.session().set(key, value);
                }
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected Serializable getSessionVariable(String key, Serializable defaultValue, boolean interpret) {
        try {
            Serializable result = this.session().get(key);
            if (result == null) {
                result = defaultValue;
            }
            if (interpret && result != null) {
                result = this.getServer().interpretVariable(key, result, this.session());
            }
            return result;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public String readLine() {
        return this.console.readLine();
    }

    public static String[] getExitCommands() {
        return EXIT_COMMANDS.toArray(new String[EXIT_COMMANDS.size()]);
    }
}

