/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Properties;
import org.neo4j.util.shell.ShellClient;

public class AbstractStarter {
    protected static String getNeoPathFromArgs(String[] args) throws RemoteException {
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            return arg;
        }
        throw new IllegalArgumentException("No neo path given");
    }

    protected static void setSessionVariablesFromArgs(ShellClient client, String[] args) throws RemoteException {
        for (String arg : args) {
            if (!arg.startsWith("-")) continue;
            String[] keyAndValue = AbstractStarter.splitArgIntoKeyAndValue(arg = arg.substring(1));
            if (keyAndValue[0].equals("profile")) {
                File file = new File(keyAndValue[1]);
                AbstractStarter.applyProfile(file, client);
                continue;
            }
            if (keyAndValue[0].startsWith("D")) {
                String key = keyAndValue[0].substring(1);
                client.session().set(key, (Serializable)((Object)keyAndValue[1]));
                continue;
            }
            throw new IllegalArgumentException("Invalid argument '" + arg + "', expected profile=<file> or Dkey=value");
        }
    }

    private static void applyProfile(File file, ShellClient client) {
        InputStream in = null;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            for (Object key : properties.keySet()) {
                String stringKey = (String)key;
                String value = properties.getProperty(stringKey);
                client.session().set(stringKey, (Serializable)((Object)value));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't find profile '" + file.getAbsolutePath() + "'");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String[] splitArgIntoKeyAndValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid argument '" + arg + "' needs to be in the form key=value");
        }
        String key = arg.substring(0, index);
        String value = arg.substring(index + 1);
        return new String[]{key, value};
    }
}

