/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLister {
    private static final String CLASS_NAME_ENDING = ".class";

    public static <T> Collection<Class<? extends T>> listClassesExtendingOrImplementing(Class<? extends T> superClass, Collection<String> lookInThesePackages) {
        String classPath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        HashSet<Class<? extends T>> classes = new HashSet<Class<? extends T>>();
        while (tokenizer.hasMoreTokens()) {
            ClassLister.collectClasses(classes, superClass, lookInThesePackages, tokenizer.nextToken());
        }
        return Collections.unmodifiableCollection(classes);
    }

    private static <T> void collectClasses(Collection<Class<? extends T>> classes, Class<? extends T> superClass, Collection<String> lookInThesePackages, String classPathToken) {
        File directory = new File(classPathToken);
        if (!directory.exists()) {
            return;
        }
        try {
            if (directory.isDirectory()) {
                ClassLister.collectFromDirectory(classes, superClass, lookInThesePackages, "", directory);
            } else {
                JarFile jarFile = new JarFile(directory);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = ClassLister.fixJarEntryClassName(entry.getName());
                    ClassLister.tryCollectClass(classes, superClass, lookInThesePackages, entryName);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error collecting classes from " + classPathToken, e);
        }
    }

    private static <T> void collectFromDirectory(Collection<Class<? extends T>> classes, Class<? extends T> superClass, Collection<String> lookInThesePackages, String prefix, File directory) {
        boolean botherToBrowseFurtherDown = false;
        if (lookInThesePackages != null) {
            for (String packageName : lookInThesePackages) {
                if (!packageName.startsWith(prefix)) continue;
                botherToBrowseFurtherDown = true;
                break;
            }
        } else {
            botherToBrowseFurtherDown = true;
        }
        if (!botherToBrowseFurtherDown) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ClassLister.collectFromDirectory(classes, superClass, lookInThesePackages, ClassLister.addToPrefix(prefix, file.getName()), file);
                continue;
            }
            String className = ClassLister.addToPrefix(prefix, file.getName());
            className = ClassLister.trimFromClassEnding(className);
            ClassLister.tryCollectClass(classes, superClass, lookInThesePackages, className);
        }
    }

    private static String addToPrefix(String prefix, String toAdd) {
        String string = prefix = prefix == null ? "" : prefix;
        if (prefix.length() > 0) {
            prefix = prefix + ".";
        }
        prefix = prefix + toAdd;
        return prefix;
    }

    private static String trimFromClassEnding(String className) {
        if (className.endsWith(CLASS_NAME_ENDING)) {
            className = className.substring(0, className.length() - CLASS_NAME_ENDING.length());
        }
        return className;
    }

    private static String fixJarEntryClassName(String entryName) {
        entryName = entryName.replace(File.separatorChar, '.');
        entryName = entryName.replace('/', '.');
        return ClassLister.trimFromClassEnding(entryName);
    }

    private static <T> void tryCollectClass(Collection<Class<? extends T>> classes, Class<? extends T> superClass, Collection<String> lookInThesePackages, String className) {
        try {
            if (!ClassLister.classNameIsInPackage(className, lookInThesePackages)) {
                return;
            }
            Class<T> cls = Class.forName(className).asSubclass(superClass);
            if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) {
                return;
            }
            if (superClass.isAssignableFrom(cls)) {
                classes.add(cls);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    private static boolean classNameIsInPackage(String className, Collection<String> lookInThesePackages) {
        if (lookInThesePackages == null) {
            return true;
        }
        String packageName = ClassLister.packageForClassName(className);
        return lookInThesePackages.contains(packageName);
    }

    private static String packageForClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return className;
        }
        return className.substring(0, index);
    }
}

