/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.neo4j.util.shell.Console;
import org.neo4j.util.shell.ShellClient;

public class JLineConsole
implements Console {
    private ShellClient client;
    private Object consoleReader;
    private Object completor;
    private boolean successfulGrabAvailableCommands = true;

    public static JLineConsole newConsoleOrNullIfNotFound(ShellClient client) {
        try {
            Object consoleReader = Class.forName("jline.ConsoleReader").newInstance();
            consoleReader.getClass().getMethod("setBellEnabled", Boolean.TYPE).invoke(consoleReader, false);
            return new JLineConsole(consoleReader, client);
        }
        catch (Exception e) {
            return null;
        }
    }

    private JLineConsole(Object consoleReader, ShellClient client) {
        this.consoleReader = consoleReader;
        this.client = client;
    }

    public void format(String format, Object ... args) {
        System.out.print(format);
    }

    private void grabAvailableCommands() throws Exception {
        Class<?> completorClass = Class.forName("jline.Completor");
        if (this.completor != null) {
            this.consoleReader.getClass().getMethod("removeCompletor", completorClass).invoke(this.consoleReader, this.completor);
            this.completor = null;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        for (String command : this.client.getServer().getAllAvailableCommands()) {
            commandList.add(command);
        }
        Object commandsArray = Array.newInstance(String.class, commandList.size());
        int counter = 0;
        for (String command : commandList) {
            Array.set(commandsArray, counter++, command);
        }
        this.completor = Class.forName("jline.SimpleCompletor").getConstructor(commandsArray.getClass()).newInstance(commandsArray);
        this.consoleReader.getClass().getMethod("addCompletor", completorClass).invoke(this.consoleReader, this.completor);
    }

    public String readLine() {
        block5: {
            try {
                this.grabAvailableCommands();
                this.successfulGrabAvailableCommands = true;
            }
            catch (Exception e) {
                if (!this.successfulGrabAvailableCommands) break block5;
                System.err.println("Couldn't grab available commands: " + e.toString());
                this.successfulGrabAvailableCommands = false;
            }
        }
        try {
            return (String)this.consoleReader.getClass().getMethod("readLine", new Class[0]).invoke(this.consoleReader, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

