/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell;

import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.neo4j.util.shell.AbstractClient;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.RemoteOutput;
import org.neo4j.util.shell.RemoteSession;
import org.neo4j.util.shell.RmiLocation;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellException;
import org.neo4j.util.shell.ShellServer;

public class RemoteClient
extends AbstractClient {
    private ShellServer server;
    private RmiLocation serverLocation;
    private Session session;
    private Output out;

    public RemoteClient(RmiLocation serverLocation) throws ShellException {
        this.serverLocation = serverLocation;
        this.server = this.findRemoteServer();
        this.session = RemoteSession.newSession();
        this.out = RemoteOutput.newOutput();
    }

    private ShellServer findRemoteServer() throws ShellException {
        try {
            return (ShellServer)this.serverLocation.getBoundObject();
        }
        catch (RemoteException e) {
            throw new ShellException(e);
        }
    }

    public Output getOutput() {
        return this.out;
    }

    public ShellServer getServer() {
        boolean shouldTryToReconnect = this.server == null;
        try {
            if (!shouldTryToReconnect) {
                this.server.welcome();
            }
        }
        catch (RemoteException e) {
            shouldTryToReconnect = true;
        }
        Exception originException = null;
        if (shouldTryToReconnect) {
            this.server = null;
            try {
                this.server = this.findRemoteServer();
                this.getOutput().println((Serializable)((Object)"[Reconnected to server]"));
            }
            catch (ShellException ee) {
                originException = ee;
            }
            catch (RemoteException ee) {
                originException = ee;
            }
        }
        if (this.server == null) {
            throw new RuntimeException("Server closed or cannot be reached anymore: " + originException.getMessage(), originException);
        }
        return this.server;
    }

    public Session session() {
        return this.session;
    }

    protected void shutdown() {
        this.tryUnexport(this.out);
        this.tryUnexport(this.session);
    }

    private void tryUnexport(Remote remote) {
        try {
            UnicastRemoteObject.unexportObject(remote, true);
        }
        catch (NoSuchObjectException e) {
            System.out.println("Couldn't unexport:" + remote);
        }
    }
}

