/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell;

import org.neo4j.util.shell.AbstractStarter;
import org.neo4j.util.shell.LocalNeoShellServer;
import org.neo4j.util.shell.SameJvmClient;

public class StartLocalClient
extends AbstractStarter {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("ERROR: To start a local neo service and a shell client on top of that you need to supply a path to a neo store or just a new path where a new neo store will be created if it doesn't exist");
            return;
        }
        String neoDbPath = args[0];
        try {
            StartLocalClient.tryStartLocalServerAndClient(neoDbPath, args);
        }
        catch (Exception e) {
            System.err.println("Can't start client with local neo service: " + e);
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void tryStartLocalServerAndClient(String neoDbPath, String[] args) throws Exception {
        final LocalNeoShellServer server = new LocalNeoShellServer(neoDbPath);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                server.shutdown();
            }
        });
        System.out.println("NOTE: Using local neo service at '" + neoDbPath + "'");
        SameJvmClient client = new SameJvmClient(server);
        StartLocalClient.setSessionVariablesFromArgs(client, args);
        client.grabPrompt();
        server.shutdown();
    }
}

