/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell;

import org.neo4j.util.shell.AbstractStarter;
import org.neo4j.util.shell.ShellClient;
import org.neo4j.util.shell.ShellLobby;

public class StartRemoteClient
extends AbstractStarter {
    public static void main(String[] args) {
        try {
            StartRemoteClient.printGreeting(args);
            ShellClient client = ShellLobby.newClient(StartRemoteClient.getPort(args), StartRemoteClient.getShellName(args));
            StartRemoteClient.setSessionVariablesFromArgs(client, args);
            client.grabPrompt();
        }
        catch (Exception e) {
            System.err.println("Can't start client shell: " + e);
            System.exit(1);
        }
    }

    private static void printGreeting(String[] args) {
        if (args.length == 0) {
            System.out.println("NOTE: No port or RMI name specified, using default port 1337 and name 'shell'.");
        }
    }

    private static String getArg(String[] args, int index) {
        int counter = 0;
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            if (counter == index) {
                return arg;
            }
            ++counter;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private static int getPort(String[] args) {
        try {
            String arg = StartRemoteClient.getArg(args, 0);
            return arg != null ? Integer.parseInt(arg) : 1337;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1337;
        }
    }

    private static String getShellName(String[] args) {
        try {
            String arg = StartRemoteClient.getArg(args, 1);
            return arg != null ? arg : "shell";
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "shell";
        }
    }
}

