/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.shell.apps.extra;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Map;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.ShellException;
import org.neo4j.util.shell.apps.extra.ScriptExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JshExecutor
extends ScriptExecutor {
    private static final String INTERPRETER_CLASS = "org.python.util.PythonInterpreter";

    private static String tryFindEnvironmentVariable(String ... examples) {
        Map<String, String> env = System.getenv();
        for (String example : examples) {
            for (String envKey : env.keySet()) {
                if (!envKey.contains(example)) continue;
                return env.get(envKey);
            }
        }
        return null;
    }

    @Override
    protected void ensureDependenciesAreInClasspath() throws ShellException {
        try {
            Class.forName(INTERPRETER_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new ShellException("Jython not found in the classpath", e);
        }
    }

    @Override
    protected String getPathKey() {
        return "JSH_PATH";
    }

    @Override
    protected Object newInterpreter(String[] paths) throws ShellException {
        try {
            return Class.forName(INTERPRETER_CLASS).newInstance();
        }
        catch (Exception e) {
            throw new ShellException("Invalid jython classes", e);
        }
    }

    @Override
    protected void runScript(Object interpreter, String scriptName, Map<String, Object> properties, String[] paths) throws ShellException {
        File scriptFile = this.findScriptFile(scriptName, paths);
        try {
            Output out = (Output)properties.remove("out");
            interpreter.getClass().getMethod("setOut", Writer.class).invoke(interpreter, new OutputWriter(out));
            Method setMethod = interpreter.getClass().getMethod("set", String.class, Object.class);
            for (String key : properties.keySet()) {
                setMethod.invoke(interpreter, key, properties.get(key));
            }
            interpreter.getClass().getMethod("execfile", String.class).invoke(interpreter, scriptFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new ShellException("Jython exception: " + this.stackTraceAsString(e));
        }
    }

    private File findScriptFile(String scriptName, String[] paths) throws ShellException {
        for (String path : paths) {
            File result = this.findScriptFile(scriptName, path);
            if (result == null) continue;
            return result;
        }
        throw new ShellException("No script '" + scriptName + "' found");
    }

    private File findScriptFile(String scriptName, String path) {
        File pathFile = new File(path);
        if (!pathFile.exists()) {
            return null;
        }
        for (File file : pathFile.listFiles()) {
            String extension;
            String name = file.getName();
            int dotIndex = name.lastIndexOf(46);
            name = dotIndex == -1 ? name : name.substring(0, dotIndex);
            String string = extension = dotIndex == -1 ? null : file.getName().substring(dotIndex + 1);
            if (!scriptName.equals(name) || extension != null && !extension.toLowerCase().equals("py")) continue;
            return file;
        }
        return null;
    }

    static {
        String jythonSystemVariableName = "python.home";
        if (System.getProperty(jythonSystemVariableName) == null) {
            String variable = JshExecutor.tryFindEnvironmentVariable("JYTHON_HOME", "JYTHONHOME", "JYTHON", "PYTHON_HOME", "PYTHONHOME", "PYTHON");
            variable = variable == null ? "/usr/local/jython" : variable;
            System.setProperty(jythonSystemVariableName, variable);
        }
    }

    private static class OutputWriter
    extends Writer {
        private Output out;

        OutputWriter(Output out) {
            this.out = out;
        }

        public Writer append(char c) throws IOException {
            this.out.append(c);
            return this;
        }

        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.out.append(csq, start, end);
            return this;
        }

        public Writer append(CharSequence csq) throws IOException {
            this.out.append(csq);
            return this;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.out.print((Serializable)((Object)new String(cbuf, off, len)));
        }

        public void write(char[] cbuf) throws IOException {
            this.out.print((Serializable)((Object)new String(cbuf)));
        }

        public void write(int c) throws IOException {
            this.out.print((Serializable)((Object)String.valueOf(c)));
        }

        public void write(String str, int off, int len) throws IOException {
            char[] cbuf = new char[len];
            str.getChars(off, off + len, cbuf, 0);
            this.write(cbuf, off, len);
        }

        public void write(String str) throws IOException {
            this.out.print((Serializable)((Object)str));
        }
    }
}

