/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.util.lookup.ServiceProvider;
import org.openide.util.lookup.ServiceProviders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"org.openide.util.lookup.ServiceProvider", "org.openide.util.lookup.ServiceProviders"})
public class ServiceProviderProcessor
extends AbstractProcessor {
    private final Map<String, List<String>> outputFiles = new HashMap<String, List<String>>();
    private final Map<String, List<Element>> originatingElements = new HashMap<String, List<Element>>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement clazz;
        if (roundEnv.errorRaised()) {
            return false;
        }
        if (roundEnv.processingOver()) {
            this.writeServices();
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceProvider.class)) {
            clazz = (TypeElement)element;
            if (!this.verifyServiceProviderSignature(clazz)) continue;
            ServiceProvider sp = clazz.getAnnotation(ServiceProvider.class);
            this.register(clazz, sp);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ServiceProviders.class)) {
            clazz = (TypeElement)element;
            if (!this.verifyServiceProviderSignature(clazz)) continue;
            ServiceProviders spp = clazz.getAnnotation(ServiceProviders.class);
            for (ServiceProvider sp : spp.value()) {
                this.register(clazz, sp);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(TypeElement clazz, ServiceProvider svc) {
        try {
            svc.service();
            assert (false);
            return;
        }
        catch (MirroredTypeException e) {
            int idx;
            TypeMirror type = e.getTypeMirror();
            String impl = this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
            String xface = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement(type)).toString();
            if (!this.processingEnv.getTypeUtils().isAssignable(clazz.asType(), type)) {
                AnnotationMirror ann = this.findAnnotationMirror(clazz, ServiceProvider.class);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, impl + " is not assignable to " + xface, clazz, ann, this.findAnnotationValue(ann, "service"));
                return;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, impl + " to be registered as a " + xface);
            String rsrc = (svc.path().length() > 0 ? "META-INF/namedservices/" + svc.path() + "/" : "META-INF/services/") + xface;
            List<Element> origEls = this.originatingElements.get(rsrc);
            if (origEls == null) {
                origEls = new ArrayList<Element>();
                this.originatingElements.put(rsrc, origEls);
            }
            origEls.add(clazz);
            List<String> lines = this.outputFiles.get(rsrc);
            if (lines == null) {
                lines = new ArrayList<String>();
                try {
                    try {
                        FileObject in = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", rsrc);
                        in.openInputStream().close();
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot generate " + rsrc + " because it already exists in sources: " + in.toUri());
                        return;
                    }
                    catch (FileNotFoundException x) {
                        try {
                            FileObject in = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", rsrc);
                            InputStream is = in.openInputStream();
                            try {
                                String line;
                                BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                                while ((line = r.readLine()) != null) {
                                    lines.add(line);
                                }
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (FileNotFoundException x2) {}
                    }
                }
                catch (IOException x) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
                    return;
                }
                this.outputFiles.put(rsrc, lines);
            }
            if ((idx = lines.indexOf(impl)) != -1) {
                lines.remove(idx);
                while (lines.size() > idx && lines.get(idx).matches("#position=.+|#-.+")) {
                    lines.remove(idx);
                }
            }
            lines.add(impl);
            if (svc.position() != Integer.MAX_VALUE) {
                lines.add("#position=" + svc.position());
            }
            for (String exclude : svc.supersedes()) {
                lines.add("#-" + exclude);
            }
            return;
        }
    }

    private boolean verifyServiceProviderSignature(TypeElement clazz) {
        AnnotationMirror ann = this.findAnnotationMirror(clazz, ServiceProvider.class);
        if (!clazz.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must be public", clazz, ann);
            return false;
        }
        if (clazz.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must not be abstract", clazz, ann);
            return false;
        }
        boolean hasDefaultCtor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(clazz.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
            hasDefaultCtor = true;
            break;
        }
        if (!hasDefaultCtor) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz + " must have a public no-argument constructor", clazz, ann);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServices() {
        for (Map.Entry<String, List<String>> entry : this.outputFiles.entrySet()) {
            try {
                FileObject out = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", entry.getKey(), this.originatingElements.get(entry.getKey()).toArray(new Element[0]));
                OutputStream os = out.openOutputStream();
                try {
                    PrintWriter w = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                    for (String line : entry.getValue()) {
                        w.println(line);
                    }
                    w.flush();
                    w.close();
                }
                finally {
                    os.close();
                }
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write to " + entry.getKey() + ": " + x.toString());
            }
        }
    }

    private AnnotationMirror findAnnotationMirror(Element element, Class<? extends Annotation> annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(annotation.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private AnnotationValue findAnnotationValue(AnnotationMirror annotation, String name) {
        if (annotation != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals(name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

