/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.event.EventListenerList;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.TransferListener;

public class ExTransferable
implements Transferable {
    public static final Transferable EMPTY = new Empty();
    public static final DataFlavor multiFlavor;
    private LinkedHashMap<DataFlavor, Single> map = new LinkedHashMap();
    private EventListenerList listeners;

    private ExTransferable(final Transferable t) {
        final DataFlavor[] df = t.getTransferDataFlavors();
        if (df != null) {
            for (int i = 0; i < df.length; ++i) {
                try {
                    final int fi = i;
                    this.map.put(df[i], new Single(df[i]){

                        public Object getData() throws IOException, UnsupportedFlavorException {
                            return t.getTransferData(df[fi]);
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void put(Single single) {
        this.map.put(single.flavor, single);
    }

    public void remove(DataFlavor flavor) {
        this.map.remove(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.map.keySet().toArray(new DataFlavor[0]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.map.containsKey(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Single o = this.map.get(flavor);
        if (o == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return o.getTransferData(flavor);
    }

    public static ExTransferable create(Transferable t) {
        if (t instanceof ExTransferable) {
            return (ExTransferable)t;
        }
        return new ExTransferable(t);
    }

    public final synchronized void addTransferListener(TransferListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(TransferListener.class, l);
    }

    public final synchronized void removeTransferListener(TransferListener l) {
        if (this.listeners != null) {
            this.listeners.remove(TransferListener.class, l);
        }
    }

    final void fireAccepted(int action) {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        for (int i = arr.length - 1; i >= 0; i -= 2) {
            ((TransferListener)arr[i]).accepted(action);
        }
    }

    final void fireRejected() {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        for (int i = arr.length - 1; i >= 0; i -= 2) {
            ((TransferListener)arr[i]).rejected();
        }
    }

    final void fireOwnershipLost() {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        for (int i = arr.length - 1; i >= 0; i -= 2) {
            ((TransferListener)arr[i]).ownershipLost();
        }
    }

    static {
        try {
            multiFlavor = new DataFlavor("application/x-java-openide-multinode;class=org.openide.util.datatransfer.MultiTransferObject", NbBundle.getBundle(ExTransferable.class).getString("transferFlavorsMultiFlavorName"), MultiTransferObject.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class Empty
    implements Transferable {
        Empty() {
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            throw new UnsupportedFlavorException(flavor);
        }
    }

    public static class Multi
    implements Transferable {
        private static final DataFlavor[] flavorList = new DataFlavor[]{multiFlavor};
        private MultiTransferObject transferObject;

        public Multi(Transferable[] trans) {
            this.transferObject = new TransferObjectImpl(trans);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return flavorList;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(multiFlavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferObject;
        }

        static class TransferObjectImpl
        implements MultiTransferObject {
            private Transferable[] trans;

            public TransferObjectImpl(Transferable[] trans) {
                this.trans = trans;
            }

            public int getCount() {
                return this.trans.length;
            }

            public Transferable getTransferableAt(int index) {
                return this.trans[index];
            }

            public boolean isDataFlavorSupported(int index, DataFlavor flavor) {
                try {
                    return this.trans[index].isDataFlavorSupported(flavor);
                }
                catch (Exception e) {
                    return false;
                }
            }

            public boolean areDataFlavorsSupported(DataFlavor[] array) {
                int i;
                HashSet<DataFlavor> flav = new HashSet<DataFlavor>();
                for (i = 0; i < array.length; ++i) {
                    flav.add(array[i]);
                }
                block1: for (i = 0; i < this.trans.length; ++i) {
                    DataFlavor[] flavors = this.trans[i].getTransferDataFlavors();
                    if (flavors == null) {
                        return false;
                    }
                    for (int j = 0; j < flavors.length; ++j) {
                        if (flav.contains(flavors[j])) continue block1;
                    }
                    return false;
                }
                return true;
            }

            public DataFlavor[] getTransferDataFlavors(int i) {
                return this.trans[i].getTransferDataFlavors();
            }

            public Object getTransferData(int indx, DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return this.trans[indx].getTransferData(flavor);
            }
        }
    }

    public static abstract class Single
    implements Transferable {
        private DataFlavor flavor;

        public Single(DataFlavor flavor) {
            this.flavor = flavor;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavor.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.flavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.getData();
        }

        protected abstract Object getData() throws IOException, UnsupportedFlavorException;
    }
}

