/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.DelegatingStorage;
import org.openide.util.lookup.InheritanceTree;
import org.openide.util.lookup.WaitableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractLookup
extends Lookup
implements Serializable {
    static final long serialVersionUID = 5L;
    private static Object treeLock = new Object();
    private Object tree;
    private int count;

    public AbstractLookup(Content content) {
        content.attach(this);
    }

    AbstractLookup(Content content, Storage<?> storage) {
        this(content);
        this.tree = storage;
        this.initialize();
    }

    AbstractLookup(Content content, Integer trashhold) {
        this(content);
        this.tree = trashhold;
    }

    protected AbstractLookup() {
    }

    public String toString() {
        if (this.tree instanceof Storage) {
            return "AbstractLookup" + this.lookup(new Lookup.Template<Object>(Object.class)).allItems();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Storage<T> enterStorage() {
        while (true) {
            Object object = treeLock;
            synchronized (object) {
                if (this.tree instanceof Storage) {
                    if (this.tree instanceof DelegatingStorage) {
                        DelegatingStorage del = (DelegatingStorage)this.tree;
                        del.checkForTreeModification();
                        try {
                            treeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.tree = new DelegatingStorage((Storage)this.tree);
                    return (Storage)this.tree;
                }
                this.tree = this.tree instanceof Integer ? new ArrayStorage((Integer)this.tree) : new ArrayStorage();
            }
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage exitStorage() {
        Object object = treeLock;
        synchronized (object) {
            Storage stor;
            this.tree = stor = ((DelegatingStorage)this.tree).exitDelegate();
            treeLock.notifyAll();
            return stor;
        }
    }

    protected void initialize() {
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    protected final void addPair(Pair<?> pair) {
        this.addPairImpl(pair, null);
    }

    protected final void addPair(Pair<?> pair, Executor notifyIn) {
        this.addPairImpl(pair, notifyIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <Transaction> void addPairImpl(Pair<?> pair, Executor notifyIn) {
        HashSet<R> toNotify;
        block6: {
            toNotify = new HashSet<R>();
            Storage t = this.enterStorage();
            Object transaction = null;
            try {
                transaction = t.beginTransaction(-2);
                if (t.add(pair, transaction)) {
                    try {
                        pair.setIndex(t, this.count++);
                    }
                    catch (IllegalStateException ex) {
                        t.remove(pair, transaction);
                        throw ex;
                    }
                    t.endTransaction(transaction, toNotify);
                    break block6;
                }
                t.endTransaction(transaction, new HashSet<R>());
            }
            finally {
                this.exitStorage();
            }
        }
        this.notifyIn(notifyIn, toNotify);
    }

    protected final void removePair(Pair<?> pair) {
        this.removePairImpl(pair, null);
    }

    protected final void removePair(Pair<?> pair, Executor notifyIn) {
        this.removePairImpl(pair, notifyIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Transaction> void removePairImpl(Pair<?> pair, Executor notifyIn) {
        HashSet<R> toNotify = new HashSet<R>();
        Storage t = this.enterStorage();
        Object transaction = null;
        try {
            transaction = t.beginTransaction(-1);
            t.remove(pair, transaction);
            t.endTransaction(transaction, toNotify);
        }
        finally {
            this.exitStorage();
        }
        this.notifyIn(notifyIn, toNotify);
    }

    protected final void setPairs(Collection<? extends Pair> collection) {
        this.setPairs(collection, null);
    }

    protected final void setPairs(Collection<? extends Pair> collection, Executor notifyIn) {
        HashSet<R> listeners = this.setPairsAndCollectListeners(collection);
        this.notifyIn(notifyIn, listeners);
    }

    private final void notifyIn(Executor notifyIn, final HashSet<R> listeners) {
        if (notifyIn == null) {
            AbstractLookup.notifyListeners(listeners);
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Notify
        implements Runnable {
            Notify() {
            }

            @Override
            public void run() {
                AbstractLookup.notifyListeners(listeners);
            }
        }
        notifyIn.execute(new Notify());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LinkedHashSet<Pair<?>> getPairsAsLHS() {
        Storage<Object> t = this.enterStorage();
        try {
            Enumeration<Pair<Object>> en = t.lookup(Object.class);
            TreeSet arr = new TreeSet(ALPairComparator.DEFAULT);
            while (en.hasMoreElements()) {
                Pair<Object> item = en.nextElement();
                arr.add(item);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(arr);
            return linkedHashSet;
        }
        finally {
            this.exitStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <Transaction> HashSet<R> setPairsAndCollectListeners(Collection<? extends Pair> collection) {
        HashSet<R> toNotify = new HashSet<R>(27);
        Storage t = this.enterStorage();
        Object transaction = null;
        try {
            HashMap<Pair, Info> shouldBeThere = new HashMap<Pair, Info>(collection.size() * 2);
            this.count = 0;
            Iterator<? extends Pair> it = collection.iterator();
            transaction = t.beginTransaction(collection.size());
            while (it.hasNext()) {
                Pair item = it.next();
                if (t.add(item, transaction)) {
                    // empty if block
                }
                shouldBeThere.put(item, new Info(this.count++, transaction));
            }
            t.retainAll(shouldBeThere, transaction);
            t.endTransaction(transaction, toNotify);
        }
        finally {
            this.exitStorage();
        }
        return toNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeObject(ObjectOutputStream oos) throws IOException {
        Storage s = this.enterStorage();
        try {
            s.beginTransaction(Integer.MAX_VALUE);
            oos.defaultWriteObject();
        }
        finally {
            this.exitStorage();
        }
    }

    @Override
    public final <T> T lookup(Class<T> clazz) {
        Lookup.Item<T> item = this.lookupItem(new Lookup.Template<T>(clazz));
        return item == null ? null : (T)item.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        this.beforeLookup(template);
        ArrayList list = null;
        Storage t = this.enterStorage();
        try {
            Enumeration<Pair<T>> en = t.lookup(template.getType());
            Pair<T> pair = AbstractLookup.findSmallest(en, template, false);
            return pair;
        }
        catch (ISE ex) {
            list = new ArrayList();
            Enumeration en = t.lookup(null);
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
        }
        finally {
            this.exitStorage();
        }
        return AbstractLookup.findSmallest(Collections.enumeration(list), template, true);
    }

    private static <T> Pair<T> findSmallest(Enumeration<Pair<T>> en, Lookup.Template<T> template, boolean deepCheck) {
        int smallest = InheritanceTree.unsorted(en) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        Pair<T> res = null;
        while (en.hasMoreElements()) {
            Pair<T> item = en.nextElement();
            if (!AbstractLookup.matches(template, item, deepCheck)) continue;
            if (smallest == Integer.MIN_VALUE) {
                return item;
            }
            if (smallest <= item.getIndex()) continue;
            smallest = item.getIndex();
            res = item;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        while (true) {
            ISE toRun = null;
            Storage<T> t = this.enterStorage();
            try {
                R r = new R();
                ReferenceToResult newRef = new ReferenceToResult(r, this, template);
                newRef.next = t.registerReferenceToResult(newRef);
                R r2 = r;
                return r2;
            }
            catch (ISE ex) {
                toRun = ex;
            }
            finally {
                this.exitStorage();
            }
            toRun.recover(this);
        }
    }

    static void notifyListeners(Set<R> allAffectedResults) {
        if (allAffectedResults.isEmpty()) {
            return;
        }
        ArrayList<Object> evAndListeners = new ArrayList<Object>();
        for (R result : allAffectedResults) {
            result.collectFires(evAndListeners);
        }
        Iterator it = evAndListeners.iterator();
        while (it.hasNext()) {
            LookupEvent ev = (LookupEvent)it.next();
            LookupListener l = (LookupListener)it.next();
            l.resultChanged(ev);
        }
    }

    static void notifyListeners(Object[] listeners, LookupEvent ev, Collection<Object> evAndListeners) {
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!(listeners[i] instanceof LookupListener)) continue;
            LookupListener ll = (LookupListener)listeners[i];
            try {
                if (evAndListeners != null) {
                    if (ll instanceof WaitableResult) {
                        WaitableResult wr = (WaitableResult)((Object)ll);
                        wr.collectFires(evAndListeners);
                        continue;
                    }
                    evAndListeners.add(ev);
                    evAndListeners.add(ll);
                    continue;
                }
                ll.resultChanged(ev);
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    static boolean matches(Lookup.Template<?> t, Pair<?> item, boolean deepCheck) {
        String id = t.getId();
        if (id != null && !id.equals(item.getId())) {
            return false;
        }
        Object instance = t.getInstance();
        if (instance != null && !item.creatorOf(instance)) {
            return false;
        }
        if (deepCheck) {
            return item.instanceOf(t.getType());
        }
        return true;
    }

    private static boolean compareArrays(Object[] a, Object[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) {
                if (b[i] == null) continue;
                return false;
            }
            if (b[i] == null) {
                return false;
            }
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean cleanUpResult(Lookup.Template<T> template) {
        Storage<T> t = this.enterStorage();
        try {
            boolean bl = t.cleanUpResult(template) == null;
            return bl;
        }
        finally {
            this.exitStorage();
        }
    }

    static boolean isSimple(AbstractLookup l) {
        return DelegatingStorage.isSimple((Storage)l.tree);
    }

    static Object modifyListenerList(boolean add, LookupListener l, Object ref) {
        if (add) {
            if (ref == null) {
                return l;
            }
            if (ref instanceof LookupListener) {
                ArrayList arr = new ArrayList();
                arr.add(ref);
                ref = arr;
            }
            ((ArrayList)ref).add(l);
            return ref;
        }
        if (ref == null) {
            return null;
        }
        if (ref == l) {
            return null;
        }
        ArrayList arr = ref;
        arr.remove(l);
        if (arr.size() == 1) {
            return arr.iterator().next();
        }
        return arr;
    }

    private static ReferenceQueue<Object> activeQueue() {
        return Utilities.activeReferenceQueue();
    }

    static final class ISE
    extends IllegalStateException {
        static final long serialVersionUID = 100L;
        private List<Job> jobs;

        public ISE(String msg) {
            super(msg);
        }

        public void registerJob(Job job) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<Job>();
            }
            this.jobs.add(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover(AbstractLookup lookup) {
            if (this.jobs == null) {
                throw this;
            }
            for (Job j : this.jobs) {
                j.before();
            }
            Storage s = lookup.enterStorage();
            try {
                for (Job j : this.jobs) {
                    j.inside();
                }
            }
            finally {
                lookup.exitStorage();
            }
        }

        static interface Job {
            public void before();

            public void inside();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReferenceIterator {
        private ReferenceToResult<?> first;
        private ReferenceToResult<?> current;
        private R<?> currentResult;

        public ReferenceIterator(ReferenceToResult<?> first) {
            this.first = first;
        }

        public boolean next() {
            ReferenceToResult prev;
            ReferenceToResult ref;
            if (this.current == null) {
                ref = this.first;
                prev = null;
            } else {
                prev = this.current;
                ref = ((ReferenceToResult)this.current).next;
            }
            while (ref != null) {
                R result = (R)ref.get();
                if (result == null) {
                    if (prev == null) {
                        this.first = ref.next;
                    } else {
                        prev.next = (ReferenceToResult)ref.next;
                    }
                    prev = ref;
                    ref = ref.next;
                    continue;
                }
                this.currentResult = result;
                this.current = ref;
                return true;
            }
            this.currentResult = null;
            this.current = null;
            return false;
        }

        public ReferenceToResult<?> current() {
            return this.current;
        }

        public ReferenceToResult<?> first() {
            return this.first;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReferenceToResult<T>
    extends WeakReference<R<T>>
    implements Runnable {
        private ReferenceToResult<?> next;
        public final Lookup.Template<T> template;
        public final AbstractLookup lookup;
        public Object caches;

        private ReferenceToResult(R<T> result, AbstractLookup lookup, Lookup.Template<T> template) {
            super(result, AbstractLookup.activeQueue());
            this.template = template;
            this.lookup = lookup;
            this.getResult().reference = this;
        }

        R<T> getResult() {
            return (R)this.get();
        }

        @Override
        public void run() {
            this.lookup.cleanUpResult(this.template);
        }

        public void cloneList(Storage<?> storage) {
            ReferenceIterator it = new ReferenceIterator(this);
            while (it.next()) {
                ReferenceToResult<?> current = it.current();
                ReferenceToResult<?> newRef = super.cloneRef();
                newRef.next = storage.registerReferenceToResult(newRef);
                newRef.caches = current.caches;
                if (current.caches != current) continue;
                ((R)current.getResult()).initItems(storage);
            }
        }

        private ReferenceToResult<T> cloneRef() {
            return new ReferenceToResult<T>(this.getResult(), this.lookup, this.template);
        }
    }

    static final class Info {
        public int index;
        public Object transaction;

        public Info(int i, Object t) {
            this.index = i;
            this.transaction = t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Content
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AbstractLookup al;
        private transient Object notifyIn;

        public Content() {
            this(null);
        }

        public Content(Executor notifyIn) {
            this.notifyIn = notifyIn;
        }

        final void attachExecutor(Executor notifyIn) {
            this.notifyIn = notifyIn;
        }

        final synchronized void attach(AbstractLookup al) {
            if (this.al == null) {
                this.al = al;
                ArrayList<Pair> ep = this.getEarlyPairs();
                if (ep != null) {
                    this.notifyIn = null;
                    this.setPairs(ep);
                }
            } else {
                throw new IllegalStateException("Trying to use content for " + al + " but it is already used for " + this.al);
            }
        }

        public final void addPair(Pair<?> pair) {
            AbstractLookup a = this.al;
            Executor e = this.getExecutor();
            if (a != null || e != null) {
                a.addPair(pair, e);
            } else {
                if (this.notifyIn == null) {
                    this.notifyIn = new ArrayList(3);
                }
                this.getEarlyPairs().add(pair);
            }
        }

        public final void removePair(Pair<?> pair) {
            AbstractLookup a = this.al;
            Executor e = this.getExecutor();
            if (a != null || e != null) {
                a.removePair(pair, e);
            } else {
                if (this.notifyIn == null) {
                    this.notifyIn = new ArrayList(3);
                }
                this.getEarlyPairs().remove(pair);
            }
        }

        public final void setPairs(Collection<? extends Pair> c) {
            AbstractLookup a = this.al;
            Executor e = this.getExecutor();
            if (a != null || e != null) {
                a.setPairs(c, e);
            } else {
                this.notifyIn = new ArrayList<Pair>(c);
            }
        }

        private ArrayList<Pair> getEarlyPairs() {
            Object o = this.notifyIn;
            return o instanceof ArrayList ? (ArrayList)o : null;
        }

        private Executor getExecutor() {
            Object o = this.notifyIn;
            return o instanceof Executor ? (Executor)o : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class R<T>
    extends WaitableResult<T> {
        public ReferenceToResult<T> reference;
        private Object listeners;

        private boolean isSimple() {
            Storage s = (Storage)this.reference.lookup.tree;
            return DelegatingStorage.isSimple(s);
        }

        private Object getFromCache(int indx) {
            if (this.isSimple()) {
                return null;
            }
            Object maybeArray = this.reference.caches;
            if (maybeArray instanceof Object[]) {
                return ((Object[])maybeArray)[indx];
            }
            return null;
        }

        private Set<Class<? extends T>> getClassesCache() {
            return (Set)this.getFromCache(0);
        }

        private void setClassesCache(Set s) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[0] = s;
        }

        private Collection<T> getInstancesCache() {
            return (Collection)this.getFromCache(1);
        }

        private void setInstancesCache(Collection c) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[1] = c;
        }

        private Pair<T>[] getItemsCache() {
            return (Pair[])this.getFromCache(2);
        }

        private void setItemsCache(Collection<?> c) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[2] = c.toArray(new Pair[0]);
        }

        private void clearCaches() {
            if (this.reference.caches instanceof Object[]) {
                this.reference.caches = new Object[3];
            }
        }

        @Override
        public synchronized void addLookupListener(LookupListener l) {
            this.listeners = AbstractLookup.modifyListenerList(true, l, this.listeners);
        }

        @Override
        public synchronized void removeLookupListener(LookupListener l) {
            this.listeners = AbstractLookup.modifyListenerList(false, l, this.listeners);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            Object[] arr;
            Object[] newArray;
            Object[] previousItems = this.getItemsCache();
            this.clearCaches();
            if (previousItems != null && AbstractLookup.compareArrays(previousItems, newArray = this.allItemsWithoutBeforeLookup().toArray())) {
                return;
            }
            R r = this;
            synchronized (r) {
                if (this.listeners == null) {
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    arr = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    ArrayList l = (ArrayList)this.listeners;
                    arr = l.toArray(new LookupListener[l.size()]);
                }
            }
            Object[] ll = arr;
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(ll, ev, evAndListeners);
        }

        @Override
        public Collection<T> allInstances() {
            this.reference.lookup.beforeLookup(this.reference.template);
            Collection<T> s = this.getInstancesCache();
            if (s != null) {
                return s;
            }
            Collection<Pair<T>> items = this.allItemsWithoutBeforeLookup();
            ArrayList list = new ArrayList(items.size());
            for (Pair<T> item : items) {
                Object obj = item.getInstance();
                if (!this.reference.template.getType().isInstance(obj)) continue;
                list.add(obj);
            }
            s = Collections.unmodifiableList(list);
            this.setInstancesCache(s);
            return s;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            this.reference.lookup.beforeLookup(this.reference.template);
            Set<Class<T>> s = this.getClassesCache();
            if (s != null) {
                return s;
            }
            s = new HashSet<Class<? extends T>>();
            for (Pair<T> item : this.allItemsWithoutBeforeLookup()) {
                Class clazz = item.getType();
                if (clazz == null) continue;
                s.add(clazz);
            }
            s = Collections.unmodifiableSet(s);
            this.setClassesCache(s);
            return s;
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            this.reference.lookup.beforeLookup(this.reference.template);
            return this.allItemsWithoutBeforeLookup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<Pair<T>> allItemsWithoutBeforeLookup() {
            Pair<T>[] c = this.getItemsCache();
            if (c != null) {
                return Collections.unmodifiableList(Arrays.asList(c));
            }
            ArrayList<Pair<Object>> saferCheck = null;
            Storage t = this.reference.lookup.enterStorage();
            try {
                Collection<Pair<T>> collection = Collections.unmodifiableCollection(this.initItems(t));
                return collection;
            }
            catch (ISE ex) {
                saferCheck = new ArrayList<Pair<Object>>();
                Enumeration en = t.lookup(null);
                while (en.hasMoreElements()) {
                    Pair i = en.nextElement();
                    saferCheck.add(i);
                }
            }
            finally {
                this.reference.lookup.exitStorage();
            }
            return this.extractPairs(saferCheck);
        }

        private Collection<Pair<T>> extractPairs(ArrayList<Pair<Object>> saferCheck) {
            TreeSet items = new TreeSet(ALPairComparator.DEFAULT);
            for (Pair<Object> i : saferCheck) {
                if (!AbstractLookup.matches(this.reference.template, i, false)) continue;
                items.add(i);
            }
            return Collections.unmodifiableCollection(items);
        }

        private Collection<Pair<T>> initItems(Storage<?> t) {
            Enumeration en = t.lookup(this.reference.template.getType());
            TreeSet<Pair<T>> items = new TreeSet<Pair<T>>(ALPairComparator.DEFAULT);
            while (en.hasMoreElements()) {
                Pair i = en.nextElement();
                if (!AbstractLookup.matches(this.reference.template, i, false)) continue;
                items.add(i);
            }
            this.setItemsCache(items);
            return items;
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            if (t.getType() == this.reference.template.getType()) {
                this.reference.lookup.beforeLookup(t);
            }
        }

        public String toString() {
            return super.toString() + " for " + this.reference.template;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Pair<T>
    extends Lookup.Item<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int index = -1;

        protected Pair() {
        }

        final int getIndex() {
            return this.index;
        }

        final void setIndex(Storage<?> tree, int x) {
            if (tree == null) {
                this.index = x;
                return;
            }
            if (this.index != -1) {
                throw new IllegalStateException("You cannot use " + this + " in more than one AbstractLookup. Prev: " + this.index + " new: " + x);
            }
            this.index = x;
        }

        protected abstract boolean instanceOf(Class<?> var1);

        protected abstract boolean creatorOf(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Storage<Transaction> {
        public Transaction beginTransaction(int var1);

        public void endTransaction(Transaction var1, Set<R> var2);

        public boolean add(Pair<?> var1, Transaction var2);

        public void remove(Pair var1, Transaction var2);

        public void retainAll(Map var1, Transaction var2);

        public <T> Enumeration<Pair<T>> lookup(Class<T> var1);

        public ReferenceToResult<?> registerReferenceToResult(ReferenceToResult<?> var1);

        public ReferenceToResult<?> cleanUpResult(Lookup.Template<?> var1);
    }
}

