/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MetaInfServicesLookup
extends AbstractLookup {
    private static final Logger LOGGER = Logger.getLogger(MetaInfServicesLookup.class.getName());
    private static final Map<Class, Object> knownInstances = new WeakHashMap<Class, Object>();
    private final Set<Class> classes = new WeakSet<Class>();
    private final ClassLoader loader;
    private final String prefix;

    public MetaInfServicesLookup(ClassLoader loader, String prefix) {
        this.loader = loader;
        this.prefix = prefix;
        LOGGER.log(Level.FINE, "Created: {0}", this);
    }

    @Override
    public String toString() {
        return "MetaInfServicesLookup[" + this.loader + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void beforeLookup(Lookup.Template t) {
        HashSet<AbstractLookup.R> listeners;
        Class c = t.getType();
        MetaInfServicesLookup metaInfServicesLookup = this;
        synchronized (metaInfServicesLookup) {
            if (!this.classes.add(c)) {
                return;
            }
            LinkedHashSet<AbstractLookup.Pair<?>> arr = this.getPairsAsLHS();
            this.search(c, arr);
            listeners = this.setPairsAndCollectListeners(arr);
        }
        MetaInfServicesLookup.notifyListeners(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Class<?> clazz, Collection<AbstractLookup.Pair<?>> result) {
        Enumeration<URL> en;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Searching for " + clazz.getName() + " in " + clazz.getClassLoader() + " from " + this);
        }
        String res = this.prefix + clazz.getName();
        try {
            en = this.loader.getResources(res);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        ArrayList<Item> foundClasses = new ArrayList<Item>();
        ArrayList removeClasses = new ArrayList();
        boolean foundOne = false;
        while (en.hasMoreElements()) {
            if (!foundOne) {
                foundOne = true;
                Class<?> realMcCoy = null;
                try {
                    realMcCoy = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (realMcCoy != clazz) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        if (realMcCoy != null) {
                            LOGGER.log(Level.WARNING, clazz.getName() + " is not the real McCoy! Actually found it in " + realMcCoy.getClassLoader());
                        } else {
                            LOGGER.log(Level.WARNING, clazz.getName() + " could not be found in " + this.loader);
                        }
                    }
                    return;
                }
            }
            URL url = en.nextElement();
            Item currentItem = null;
            try {
                InputStream is = url.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith("#position=")) {
                            if (currentItem == null) {
                                LOGGER.log(Level.WARNING, "Found line '{0}' in {1} but there is no item to associate it with", new Object[]{line, url});
                                continue;
                            }
                            try {
                                currentItem.position = Integer.parseInt(line.substring(10));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (currentItem != null) {
                            this.insertItem(currentItem, foundClasses);
                            currentItem = null;
                        }
                        if (line.length() == 0) continue;
                        boolean remove = false;
                        if (line.charAt(0) == '#') {
                            if (line.length() == 1 || line.charAt(1) != '-') continue;
                            remove = true;
                            line = line.substring(2);
                        }
                        Class<?> inst = null;
                        try {
                            inst = Class.forName(line, false, this.loader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            if (remove) continue;
                            throw cnfe;
                        }
                        if (!clazz.isAssignableFrom(inst)) {
                            throw new ClassNotFoundException(MetaInfServicesLookup.clazzToString(inst) + " not a subclass of " + MetaInfServicesLookup.clazzToString(clazz));
                        }
                        if (remove) {
                            removeClasses.add(inst);
                            continue;
                        }
                        currentItem = new Item();
                        currentItem.clazz = inst;
                    }
                    if (currentItem == null) continue;
                    this.insertItem(currentItem, foundClasses);
                    currentItem = null;
                }
                finally {
                    is.close();
                }
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        LOGGER.log(Level.FINER, "Found impls of {0}: {1} and removed: {2} from: {3}", new Object[]{clazz.getName(), foundClasses, removeClasses, this});
        foundClasses.removeAll(removeClasses);
        for (Item item : foundClasses) {
            if (removeClasses.contains(item.clazz)) continue;
            result.add(new P(item.clazz));
        }
    }

    private static String clazzToString(Class clazz) {
        return clazz.getName() + "@" + clazz.getClassLoader() + ":" + clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    private void insertItem(Item item, List<Item> list) {
        if (item.position == -1) {
            list.add(item);
            return;
        }
        int index = -1;
        for (Item i : list) {
            ++index;
            if (i.position == -1) {
                list.add(index, item);
                return;
            }
            if (i.position <= item.position) continue;
            list.add(index, item);
            return;
        }
        list.add(item);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class P
    extends AbstractLookup.Pair<Object> {
        private Object object;

        public P(Class<?> clazz) {
            this.object = clazz;
        }

        private Class<? extends Object> clazz() {
            Object o = this.object;
            if (o instanceof Class) {
                return (Class)o;
            }
            if (o != null) {
                return o.getClass();
            }
            return Object.class;
        }

        public boolean equals(Object o) {
            if (o instanceof P) {
                return ((P)o).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        @Override
        protected boolean instanceOf(Class<?> c) {
            return c.isAssignableFrom(this.clazz());
        }

        @Override
        public Class<?> getType() {
            return this.clazz();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getInstance() {
            Object o = this.object;
            if (o instanceof Class) {
                Object object = o;
                synchronized (object) {
                    try {
                        Class c = (Class)o;
                        Map map = knownInstances;
                        synchronized (map) {
                            o = knownInstances.get(c);
                        }
                        if (o == null) {
                            o = SharedClassObject.class.isAssignableFrom(c) ? SharedClassObject.findObject(c.asSubclass(SharedClassObject.class), true) : c.newInstance();
                            map = knownInstances;
                            synchronized (map) {
                                knownInstances.put(c, o);
                            }
                        }
                        this.object = o;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                        this.object = null;
                    }
                }
            }
            return this.object;
        }

        @Override
        public String getDisplayName() {
            return this.clazz().getName();
        }

        @Override
        public String getId() {
            return this.clazz().getName();
        }

        @Override
        protected boolean creatorOf(Object obj) {
            return obj == this.object;
        }
    }

    private static class Item {
        private Class clazz;
        private int position = -1;

        private Item() {
        }

        public String toString() {
            return "MetaInfServicesLookup.Item[" + this.clazz.getName() + "]";
        }
    }
}

