/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.config.CMIConfigException;
import org.ow2.cmi.config.CMIProperty;
import org.ow2.cmi.config.JNDIConfig;
import org.ow2.cmi.config.ProtocolConfig;
import org.ow2.cmi.config.ProviderURLsParser;
import org.ow2.cmi.config.ProviderUrls;
import org.ow2.cmi.controller.client.Config;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.controller.factory.client.ClusterViewManagerFactoryConfig;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.XMLUtils;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.properties.SystemPropertyResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CMIConfigurator {
    public static final Object DEFAULT_FILENAME = "cmi-config.xml";
    private static Log logger = LogFactory.getLog(CMIConfigurator.class);

    private CMIConfigurator() {
    }

    public static CMIConfig<?> findAndExtractCMIConfig(Hashtable<?, ?> environment, boolean onlyJndi) throws CMIConfigException {
        CMIConfig<?> cmiConfig = CMIConfigurator.extractCMIConfig(environment, onlyJndi);
        if (cmiConfig == null) {
            URL url;
            Object filename = environment.get(CMIProperty.CONF_FILENAME.getPropertyName());
            if (filename == null) {
                filename = System.getProperty(CMIProperty.CONF_FILENAME.getPropertyName());
            }
            if (filename == null) {
                filename = DEFAULT_FILENAME;
            }
            try {
                url = CMIConfigurator.getUrlForFilename(environment, (String)filename);
            }
            catch (MalformedURLException e) {
                logger.error("Cannot configure the cluster view manager factory from the file: " + filename, e);
                throw new CMIConfigException("Cannot configure the cluster view manager factory from the file: " + filename, e);
            }
            cmiConfig = CMIConfigurator.extractCMIConfig(url);
        }
        return cmiConfig;
    }

    public static CMIConfig<?> extractCMIConfig(Hashtable<?, ?> environment, boolean onlyJndi) throws CMIConfigException {
        CMIConfig<ClusterViewManagerFactoryConfig> cmiConfig;
        org.ow2.cmi.controller.factory.ClusterViewManagerFactoryConfig clusterViewManagerFactoryConfig;
        JNDIConfig jndiConfig;
        boolean serverModeEnabled = CMIConfigurator.isServerModeEnabled(environment);
        Object managerClassname = environment.get(CMIProperty.REPLICATION_MANAGER_CLASS.getPropertyName());
        if (managerClassname != null) {
            serverModeEnabled = true;
        }
        if ((jndiConfig = CMIConfigurator.extractJNDIConfig(environment)) == null && (!serverModeEnabled || managerClassname == null || onlyJndi)) {
            return null;
        }
        if (onlyJndi) {
            CMIConfig cmiConfig2 = new CMIConfig();
            cmiConfig2.setJNDIConfig(jndiConfig);
            return cmiConfig2;
        }
        if (serverModeEnabled) {
            URL url;
            CMIConfig<org.ow2.cmi.controller.factory.server.ClusterViewManagerFactoryConfig> cmiConfigServer = new CMIConfig<org.ow2.cmi.controller.factory.server.ClusterViewManagerFactoryConfig>();
            org.ow2.cmi.controller.factory.server.ClusterViewManagerFactoryConfig serverClusterViewManagerFactoryConfig = new org.ow2.cmi.controller.factory.server.ClusterViewManagerFactoryConfig();
            if (managerClassname == null) {
                managerClassname = "org.ow2.cmi.controller.server.impl.jgroups.JGroupsClusterViewManager";
            }
            serverClusterViewManagerFactoryConfig.setServerClusterViewManagerClassname((String)managerClassname);
            clusterViewManagerFactoryConfig = serverClusterViewManagerFactoryConfig;
            cmiConfigServer.setClusterViewManagerFactoryConfig(serverClusterViewManagerFactoryConfig);
            cmiConfig = cmiConfigServer;
            Object filename = System.getProperty(CMIProperty.CONF_FILENAME.getPropertyName());
            if (filename == null) {
                filename = environment.get(CMIProperty.CONF_FILENAME.getPropertyName());
            }
            if (filename == null) {
                filename = DEFAULT_FILENAME;
            }
            try {
                url = CMIConfigurator.getUrlForFilename(environment, (String)filename);
            }
            catch (MalformedURLException e) {
                logger.error("Cannot configure the cluster view manager factory from the file: " + filename, e);
                throw new CMIConfigException("Cannot configure the cluster view manager factory from the file: " + filename, e);
            }
            XMLConfiguration xmlConfiguration = new XMLConfiguration(url, "cmi-config-mapping.xml");
            xmlConfiguration.setPropertyResolver(new SystemPropertyResolver());
            try {
                xmlConfiguration.configure(clusterViewManagerFactoryConfig);
            }
            catch (XMLConfigurationException e) {
                logger.error("Cannot configure CMI", e);
                throw new CMIConfigException("Cannot configure CMI", e);
            }
        }
        CMIConfig<ClusterViewManagerFactoryConfig> cmiConfigClient = new CMIConfig<ClusterViewManagerFactoryConfig>();
        ClusterViewManagerFactoryConfig clientClusterViewManagerFactoryConfig = new ClusterViewManagerFactoryConfig();
        clusterViewManagerFactoryConfig = clientClusterViewManagerFactoryConfig;
        cmiConfigClient.setClusterViewManagerFactoryConfig(clientClusterViewManagerFactoryConfig);
        cmiConfig = cmiConfigClient;
        Config clientConfig = new Config();
        clientClusterViewManagerFactoryConfig.setConfig(clientConfig);
        clusterViewManagerFactoryConfig.setAutoStarted(CMIConfigurator.extractAutoStart(environment));
        cmiConfig.setJNDIConfig(jndiConfig);
        return cmiConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CMIConfig<?> extractCMIConfig(URL url) throws CMIConfigException {
        CMIConfig cmiConfig;
        Element element;
        NodeList nodeList;
        int nbNodes;
        Document document;
        block13: {
            InputStream inputStream = null;
            try {
                URLConnection urlConnection = url.openConnection();
                urlConnection.setUseCaches(false);
                inputStream = urlConnection.getInputStream();
                document = DocumentParser.getDocument((InputStream)inputStream, (boolean)false, null);
                logger.info("Configuring CMI from file: {0}", url.getPath());
                if (inputStream == null) break block13;
            }
            catch (Exception e) {
                try {
                    throw new CMIConfigException("Cannot get a document on the given url '" + url + "'.", e);
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        logger.debug("Unable to close the input stream", e2);
                    }
                    throw throwable;
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.debug("Unable to close the input stream", e);
            }
        }
        if ((nbNodes = (nodeList = (element = document.getDocumentElement()).getElementsByTagName("server")).getLength()) > 1) {
            logger.error("Invalid XML configuration file: {0} nodes with name 'server' found.", nbNodes);
            throw new CMIConfigException("Invalid XML configuration file: " + nbNodes + " nodes with name 'server' found.");
        }
        if (nbNodes == 1) {
            cmiConfig = new CMIConfig();
            element = (Element)nodeList.item(0);
        } else {
            nodeList = element.getElementsByTagName("client");
            nbNodes = nodeList.getLength();
            if (nbNodes != 1) {
                logger.error("Invalid XML configuration file: {0} nodes with name 'client' found.", nbNodes);
                throw new CMIConfigException("Invalid XML configuration file: " + nbNodes + " nodes with name 'client' found.");
            }
            cmiConfig = new CMIConfig();
            element = (Element)nodeList.item(0);
            String noCmi = XMLUtils.getAttributeValue((Element)element, (String)"noCmi");
            if (Boolean.parseBoolean(noCmi)) {
                cmiConfig.setNoCmi(true);
            }
        }
        CMIConfigurator.configure(url, element, cmiConfig);
        if (System.getProperty(CMIProperty.CONF_FILENAME.getPropertyName()) != null) return cmiConfig;
        String f = url.getFile();
        int ind = f.lastIndexOf("/");
        String fileName = f.substring(ind + 1);
        System.setProperty(CMIProperty.CONF_FILENAME.getPropertyName(), fileName);
        return cmiConfig;
    }

    public static List<ServerRef> extractServerRefs(String protocol, List<String> providerURLs) throws CMIConfigException {
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol missing");
        }
        int size = providerURLs.size();
        ArrayList<ServerRef> serverRefs = new ArrayList<ServerRef>(size);
        for (String providerURL : providerURLs) {
            try {
                serverRefs.add(new ServerRef(protocol, providerURL));
            }
            catch (MalformedURLException e) {
                logger.error("The following provider URL is malformed {0}", providerURL, e);
                throw new CMIConfigException("The following provider URL is malformed " + providerURL, e);
            }
            catch (UnknownHostException e) {
                logger.error("The host name of the provider URL {0} cannot be resolved", providerURL, e);
                throw new CMIConfigException("The host name of the provider URL " + providerURL + " cannot be resolved", e);
            }
        }
        return serverRefs;
    }

    public static void configure(ClusterViewManagerFactory clusterViewManagerFactory, CMIConfig<?> cmiConfig) throws CMIConfigException {
        Object clusterViewManagerFactoryConfig = cmiConfig.getClusterViewManagerFactoryConfig();
        if (clusterViewManagerFactoryConfig == null) {
            logger.error("Cluster view manager config missing!", new Object[0]);
            throw new CMIConfigException("Cluster view manager config missing!");
        }
        if (clusterViewManagerFactoryConfig instanceof ClusterViewManagerFactoryConfig) {
            JNDIConfig jndiConfig = cmiConfig.getJNDIConfig();
            if (jndiConfig == null) {
                logger.error("JNDI config missing!", new Object[0]);
                throw new CMIConfigException("JNDI config missing!");
            }
            Set<ProtocolConfig> protocolConfigs = jndiConfig.getProtocolConfigs();
            if (protocolConfigs == null) {
                logger.error("Protocol config missing!", new Object[0]);
                throw new CMIConfigException("Protocol config missing!");
            }
            String protocol = JNDIConfig.getCurrentProtocolName();
            ProtocolConfig currentProtocolConfig = null;
            if (protocol == null) {
                if (protocolConfigs.size() != 1) {
                    logger.error("Protocol name missing!", new Object[0]);
                    throw new CMIConfigException("Protocol name missing!");
                }
                currentProtocolConfig = (ProtocolConfig)protocolConfigs.toArray()[0];
                protocol = currentProtocolConfig.getName();
            } else {
                for (ProtocolConfig protocolConfig : protocolConfigs) {
                    if (!protocolConfig.getName().equals(protocol)) continue;
                    currentProtocolConfig = protocolConfig;
                }
            }
            if (currentProtocolConfig == null) {
                logger.error("Missing configuration for " + protocol, new Object[0]);
                throw new CMIConfigException("Missing configuration for " + protocol);
            }
            String wrappedFactoryName = currentProtocolConfig.getInitialContextFactoryName();
            ProviderUrls providerUrls = currentProtocolConfig.getProviderUrls();
            if (providerUrls == null) {
                logger.error("Missing configuration for " + protocol, new Object[0]);
                throw new CMIConfigException("Missing configuration for " + protocol);
            }
            List<String> initialProviderURLs = providerUrls.getProviderUrls();
            ((ClusterViewManagerFactoryConfig)clusterViewManagerFactoryConfig).setClusterViewProviderUrls(initialProviderURLs);
            ((ClusterViewManagerFactoryConfig)clusterViewManagerFactoryConfig).setInitialContextFactoryName(wrappedFactoryName);
            ((ClusterViewManagerFactoryConfig)clusterViewManagerFactoryConfig).setProtocol(protocol);
        } else {
            String protocol = JNDIConfig.getCurrentProtocolName();
            if (protocol != null) {
                CMIConfigurator.patchProtocol(protocol);
            }
        }
        String confDir = System.getProperty(CMIProperty.CONF_DIR.getPropertyName());
        if (confDir != null) {
            ((org.ow2.cmi.controller.factory.ClusterViewManagerFactoryConfig)clusterViewManagerFactoryConfig).getConfig().setConfDir(confDir);
        }
        clusterViewManagerFactory.configure((org.ow2.cmi.controller.factory.ClusterViewManagerFactoryConfig<?>)clusterViewManagerFactoryConfig);
    }

    private static URL getUrlForFilename(Hashtable<?, ?> environment, String filename) throws MalformedURLException {
        Object confURL = environment.get(CMIProperty.CONF_DIR.getPropertyName());
        if (confURL == null) {
            confURL = System.getProperty(CMIProperty.CONF_DIR.getPropertyName());
        }
        if (confURL == null) {
            logger.warn("No configuration directory set: using the classpath", new Object[0]);
            return Thread.currentThread().getContextClassLoader().getResource(filename);
        }
        return new File((String)confURL, filename).toURI().toURL();
    }

    private static void configure(URL url, Element element, Object cmiConfig) throws CMIConfigException {
        long tStart = System.currentTimeMillis();
        logger.debug("Starting configuration of CMI", new Object[0]);
        XMLConfiguration xmlConfiguration = new XMLConfiguration(url, "cmi-config-mapping.xml");
        xmlConfiguration.setPropertyResolver(new SystemPropertyResolver());
        try {
            xmlConfiguration.configure(cmiConfig, element, null);
        }
        catch (XMLConfigurationException e) {
            logger.error("Cannot configure CMI", e);
            throw new CMIConfigException("Cannot configure CMI", e);
        }
        if (logger.isInfoEnabled()) {
            logger.debug("Configuration done in : " + (System.currentTimeMillis() - tStart) + " ms", new Object[0]);
        }
    }

    private static void patchProtocol(String protocol) {
        String proDelegate = System.getProperty("javax.rmi.CORBA.PortableRemoteObjectClass");
        logger.debug("Current PRO delegate is {0}", proDelegate);
        if (proDelegate == null || proDelegate != null && proDelegate.equals("com.sun.corba.se.impl.javax.rmi.PortableRemoteObject")) {
            logger.debug("Using the class 'org.ow2.cmi.rmi.DefaultCMIPRODelegate' as PRO delegate", new Object[0]);
            System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.cmi.rmi.DefaultCMIPRODelegate");
            if (protocol == "iiop") {
                logger.debug("Using the class 'com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryStaticImpl'as ORBDynamicStubFactoryFactory", new Object[0]);
                System.setProperty("com.sun.CORBA.ORBDynamicStubFactoryFactoryClass", "com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryStaticImpl");
            }
        }
    }

    private static JNDIConfig extractJNDIConfig(Hashtable<?, ?> environment) throws CMIConfigException {
        Object providerURLs;
        Object localRegistryUrl;
        Object protocol = environment.get(CMIProperty.WRAPPED_PROTOCOL.getPropertyName());
        if (protocol == null) {
            return null;
        }
        JNDIConfig jndiConfig = new JNDIConfig();
        ProtocolConfig protocolConfig = new ProtocolConfig();
        jndiConfig.addProtocolConfig(protocolConfig);
        protocolConfig.setName((String)protocol);
        Object initialContextFactory = environment.get(CMIProperty.WRAPPED_INITIAL_CONTEXT_FACTORY.getPropertyName());
        if (initialContextFactory != null) {
            protocolConfig.setInitialContextFactoryName((String)initialContextFactory);
        }
        if ((localRegistryUrl = environment.get(CMIProperty.LOCAL_REGISTRY_URL.getPropertyName())) != null) {
            protocolConfig.setLocalRegistryUrl((String)localRegistryUrl);
        }
        if ((providerURLs = environment.get(CMIProperty.CLUSTER_VIEW_PROVIDER_URLS.getPropertyName())) != null) {
            ProviderUrls pUrls = new ProviderUrls();
            protocolConfig.setProviderUrls(pUrls);
            try {
                pUrls.setProviderUrls(ProviderURLsParser.parse((String)providerURLs));
            }
            catch (MalformedURLException e) {
                logger.error("Cannot parse the following urls: {0}.", providerURLs, e);
                throw new CMIConfigException("Cannot parse the following urls: " + providerURLs, e);
            }
        }
        JNDIConfig.setCurrentProtocolName((String)protocol);
        return jndiConfig;
    }

    private static boolean isServerModeEnabled(Map<?, ?> bootstrapEnv) {
        Object obj = bootstrapEnv.get(CMIProperty.SERVER_MODE.getPropertyName());
        if (obj == null) {
            return false;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    private static boolean extractAutoStart(Map<?, ?> bootstrapEnv) {
        Object obj = bootstrapEnv.get(CMIProperty.AUTOSTART.getPropertyName());
        if (obj == null) {
            return true;
        }
        return Boolean.parseBoolean(obj.toString());
    }
}

