/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.admin.CMIMBeanConfigException;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.controller.client.ClientClusterViewManager;
import org.ow2.cmi.controller.common.CMIThreadFactory;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManagerException;
import org.ow2.cmi.controller.common.IConfig;
import org.ow2.cmi.controller.common.LocalObjectData;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.event.CMIEventComponent;
import org.ow2.cmi.ha.SessionId;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.util.PolicyFactory;
import org.ow2.cmi.lb.util.PolicyFactoryException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.util.component.ComponentManager;
import org.ow2.util.component.api.Component;
import org.ow2.util.component.api.ComponentException;
import org.ow2.util.component.api.IComponentManager;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbsClusterViewManager
implements ClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(AbsClusterViewManager.class);
    private ClusterViewManager.State state = ClusterViewManager.State.STOPPED;
    private final ConcurrentHashMap<String, LocalObjectData> localObjectData = new ConcurrentHashMap();
    private final Set<String> watchedObjects = Collections.synchronizedSet(new HashSet());
    private final CMIThreadFactory cmiThreadFactory;
    private final UUID uuid;
    private final AtomicLong sessionNb = new AtomicLong(0L);
    private final IEventDispatcher dispatcher;
    private IComponentManager componentManager;
    private final String cmiManagedObjectId;
    private boolean destroyed;

    protected AbsClusterViewManager() {
        String managerName = this instanceof ClientClusterViewManager ? "ClientClusterViewManager" : "ServerClusterViewManager";
        this.cmiThreadFactory = new CMIThreadFactory(managerName);
        this.uuid = UUID.randomUUID();
        this.dispatcher = new EventDispatcher();
        this.cmiManagedObjectId = "/cmi";
    }

    @Override
    public IEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    public final Component getComponent(String componentName) {
        if (this.componentManager != null) {
            return this.componentManager.getComponentRegistry().getComponent(componentName);
        }
        return null;
    }

    @Override
    public <T extends Component> T getComponent(Class<T> itf) {
        try {
            return (T)((Component)this.componentManager.getComponentRegistry().getComponents(itf).get(0));
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.debug("No component", e);
            return null;
        }
    }

    public final IComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public String getCMIManagedObjectId() {
        return this.cmiManagedObjectId;
    }

    @Override
    public final synchronized ClusterViewManager.State getState() {
        return this.state;
    }

    protected final void setState(ClusterViewManager.State state) {
        this.state = state;
    }

    @Override
    public final IPolicy<CMIReference> getPolicy(String objectName) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        return this.localObjectData.get(objectName).getPolicy();
    }

    private void setPolicy(String objectName, IPolicy<CMIReference> lbPolicy) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        this.localObjectData.get(objectName).setPolicy(lbPolicy);
    }

    protected final boolean hasPool(String objectName) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        return this.localObjectData.get(objectName).getPool() != null;
    }

    @Override
    public final Pool<CMIReferenceable<?>, CMIReference> getPool(String objectName) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        return this.localObjectData.get(objectName).getPool();
    }

    @Override
    public final void setPool(String objectName, Pool<CMIReferenceable<?>, CMIReference> pool) {
        this.localObjectData.putIfAbsent(objectName, new LocalObjectData(objectName));
        this.localObjectData.get(objectName).setPool(pool);
    }

    protected final void updatePolicy(String objectName) throws ObjectNotFoundException, PolicyFactoryException {
        LOGGER.debug("Updating policy for {0}", objectName);
        PolicyFactory policyFactory = new PolicyFactory((ClusterViewManager)this);
        IPolicy policy = policyFactory.getPolicy(objectName);
        this.setPolicy(objectName, policy);
    }

    protected final boolean isWatched(String objectName) {
        return this.watchedObjects.contains(objectName);
    }

    protected final void watch(String objectName) {
        this.watchedObjects.add(objectName);
    }

    protected final Set<String> getNamesOfWatchedObject() {
        return new HashSet<String>(this.watchedObjects);
    }

    protected final CMIThreadFactory getCmiThreadFactory() {
        return this.cmiThreadFactory;
    }

    @Override
    public final UUID getUUID() {
        return this.uuid;
    }

    @Override
    public final SessionId getSessionId() {
        return new SessionId(this.uuid, this.sessionNb.incrementAndGet());
    }

    @Override
    public final IConfig getConfig() {
        return ClusterViewManagerFactory.getFactory().getConfig();
    }

    @Override
    public final synchronized boolean start() throws ClusterViewManagerException {
        if (this.destroyed) {
            throw new ClusterViewManagerException("This instance of cluster view manager can no more be used !!!");
        }
        if (this.getConfig() == null) {
            throw new ClusterViewManagerException("This instance of cluster view manager has no configuration !!!");
        }
        if (this.getState().equals((Object)ClusterViewManager.State.STOPPED)) {
            this.setState(ClusterViewManager.State.STARTING);
            this.componentManager = new ComponentManager(this.getConfig().getComponents());
            if (this.getConfig().isAutoConfigureComponents()) {
                try {
                    this.getComponentManager().initComponents();
                }
                catch (ComponentException e) {
                    throw new ClusterViewManagerException("Cannot init components", e);
                }
                try {
                    this.getComponentManager().startComponents();
                }
                catch (ComponentException e) {
                    throw new ClusterViewManagerException("Cannot start components", e);
                }
            }
            this.getEventDispatcher().start();
            CMIEventComponent eventComponent = this.getComponent(CMIEventComponent.class);
            if (eventComponent != null) {
                eventComponent.registerCMIManagedObject(this, this.getEventDispatcher());
            }
            if (this.getConfig().isAdminEnabled()) {
                try {
                    MBeanUtils.registerCMIMBean((ClusterViewManager)this);
                }
                catch (CMIMBeanConfigException e) {
                    LOGGER.warn("Cannot registers the CMI MBean", new Object[]{e});
                }
            }
            return this.starting();
        }
        return this.getState().equals((Object)ClusterViewManager.State.AVAILABLE);
    }

    @Override
    public final synchronized void stop() {
        if (this.getState().equals((Object)ClusterViewManager.State.STARTED) || this.getState().equals((Object)ClusterViewManager.State.AVAILABLE)) {
            this.setState(ClusterViewManager.State.STOPPING);
            this.stopping();
            if (this.getConfig().isAdminEnabled()) {
                try {
                    MBeanUtils.unregisterCMIMBean();
                }
                catch (CMIMBeanConfigException e) {
                    LOGGER.error("Cannot unregister CMIMBean", new Object[]{e});
                }
            }
            this.setState(ClusterViewManager.State.STOPPED);
            LOGGER.info("Cluster view manager stopped.", new Object[0]);
        }
    }

    protected abstract boolean starting() throws ClusterViewManagerException;

    protected abstract void stopping();

    @Override
    public void destroy() {
        this.stop();
        this.destroyed = true;
    }
}

