/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.i18n;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class I18n {
    private static final String RESOURCE_BUNDLE_NAME = "I18n";
    private static final String NO_PACKAGE = "NO_PACKAGE";
    private static Map<String, I18n> bundles = null;
    private ResourceBundle resourceBundle = null;

    private I18n(String packageName, ClassLoader cl) {
        String bundleName = packageName + "." + RESOURCE_BUNDLE_NAME;
        try {
            Locale locale = Locale.getDefault();
            this.resourceBundle = ResourceBundle.getBundle(bundleName, locale, cl);
        }
        catch (MissingResourceException mre) {
            this.resourceBundle = null;
        }
    }

    public static I18n getInstance(Class<?> c) {
        return I18n.getInstance(c, c.getClassLoader());
    }

    public static I18n getInstance(Class<?> c, ClassLoader cl) {
        Package p = c.getPackage();
        if (p != null) {
            return I18n.getInstance(p.getName(), cl);
        }
        return I18n.getInstance(NO_PACKAGE, cl);
    }

    public static I18n getInstance(String packageName) {
        return I18n.getInstance(packageName, Thread.currentThread().getContextClassLoader());
    }

    public static I18n getInstance(String packageName, ClassLoader cl) {
        I18n i18n;
        if (bundles == null) {
            bundles = new HashMap<String, I18n>();
        }
        if ((i18n = bundles.get(packageName)) != null) {
            return i18n;
        }
        i18n = new I18n(packageName, cl);
        bundles.put(packageName, i18n);
        return i18n;
    }

    public String getMessage(String key, Object ... objs) {
        String pattern = key;
        if (this.resourceBundle != null) {
            try {
                pattern = this.resourceBundle.getString(key);
            }
            catch (MissingResourceException mre) {
                pattern = key;
            }
        }
        try {
            return MessageFormat.format(pattern, objs);
        }
        catch (IllegalArgumentException iae) {
            return key;
        }
    }
}

