/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester;

import ORG.oclc.oai.harvester.OAIServer;
import ORG.oclc.oai.harvester.OAIServerSet;
import ORG.oclc.util.XMLUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SimpleOAIServerSet
extends OAIServerSet {
    private static final String USAGE = "java SimpleOAIServerSet <in.xml> <out.ser>";
    private String collectionFileName;
    private static XMLUtil xmlUtil = new XMLUtil(false, false);

    public SimpleOAIServerSet(Properties properties, String baseURL, String setSpec) throws FileNotFoundException {
        super(SimpleOAIServerSet.getCollection(properties, baseURL, setSpec));
        this.collectionFileName = properties.getProperty("SimpleOAIServerSet.collectionFileName");
        if (this.collectionFileName == null) {
            throw new FileNotFoundException("SimpleOAIServerSet.collectionFileName is missing from properties file");
        }
    }

    public void store() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.collectionFileName);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.getCollection());
        oos.close();
        fos.close();
    }

    private static Collection getCollection(Properties properties, String baseURL, String setSpec) throws FileNotFoundException {
        Collection<OAIServer> collection = null;
        String collectionFileName = properties.getProperty("SimpleOAIServerSet.collectionFileName");
        if (collectionFileName == null) {
            throw new FileNotFoundException("SimpleOAIServerSet.collectionFileName is missing from properties file");
        }
        if (baseURL != null) {
            collection = new ArrayList<OAIServer>(1);
            collection.add(new OAIServer(baseURL, null, setSpec));
        } else {
            try {
                FileInputStream fis = new FileInputStream(collectionFileName);
                ObjectInputStream ois = new ObjectInputStream(fis);
                collection = (Collection)ois.readObject();
                ois.close();
                fis.close();
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return collection;
    }

    public static final void main(String[] args) {
        if (args.length < 2) {
            System.out.println(USAGE);
            return;
        }
        String inFileName = args[0];
        String outFileName = args[1];
        try {
            FileInputStream fis = new FileInputStream(inFileName);
            Document inDoc = xmlUtil.parse(fis);
            fis.close();
            int numRecs = XMLUtil.getSize(inDoc, "OAIServer");
            ArrayList<OAIServer> collection = new ArrayList<OAIServer>(numRecs);
            int i = 0;
            while (i < numRecs) {
                Element inEl = XMLUtil.getElement(inDoc, "OAIServer", i);
                String baseURL = XMLUtil.getValue(inEl, "baseURL");
                String setSpec = XMLUtil.getValue(inEl, "setSpec");
                String lastHarvestDate = XMLUtil.getValue(inEl, "lastHarvestDate");
                System.out.println("baseURL: " + baseURL + " lastHarvestDate: " + lastHarvestDate + " setSpec: " + setSpec);
                collection.add(new OAIServer(baseURL, lastHarvestDate, setSpec));
                ++i;
            }
            FileOutputStream fos = new FileOutputStream(outFileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(collection);
            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

