/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.harvester.verb.HarvesterVerb;
import ORG.oclc.oai.harvester.verb.Record;
import ORG.oclc.oai.util.OAIUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GetRecord
extends HarvesterVerb {
    private static final boolean debug = false;
    private boolean recordCapture = false;
    private StringBuffer record = new StringBuffer();
    private ArrayList records = new ArrayList();
    private HashMap xmlnsMap = new HashMap();

    public GetRecord(URL baseURL, String identifier, String metadataPrefix) throws MalformedURLException, SAXException, IOException {
        StringBuffer query = new StringBuffer();
        query.append(baseURL.toString());
        query.append("?");
        query.append(GetRecord.getParams(identifier, metadataPrefix));
        XMLReader xmlReader = this.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(this.getResponseStream(query.toString())));
        }
        catch (SAXException e) {
            System.out.println("HarvesterVerb.HarvesterVerb: query=" + query);
            e.printStackTrace();
            throw e;
        }
    }

    private static String getParams(String identifier, String metadataPrefix) throws IOException {
        try {
            StringBuffer query = new StringBuffer();
            query.append("verb=GetRecord");
            query.append("&identifier=");
            query.append(URLEncoder.encode(identifier, "UTF-8"));
            query.append("&metadataPrefix=");
            query.append(URLEncoder.encode(metadataPrefix, "UTF-8"));
            return query.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public Iterator iterator() {
        return this.records.iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        return sb.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (!this.recordCapture && fullName.equals(HarvesterVerb.OAI20_RECORD)) {
            this.record.setLength(0);
            this.recordCapture = true;
        }
        int length = attrs.getLength();
        if (this.recordCapture) {
            this.record.append("<");
            this.record.append(qName);
            int i = 0;
            while (i < length) {
                this.record.append(" ");
                String aEName = attrs.getQName(i);
                this.record.append(aEName);
                this.record.append("=\"");
                this.record.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.record.append("\"");
                if (aEName.startsWith("xmlns:")) {
                    this.xmlnsMap.remove(aEName);
                }
                ++i;
            }
            if (fullName.equals(HarvesterVerb.OAI20_RECORD)) {
                Iterator iter = this.xmlnsMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.record.append(" ").append(entry.getKey()).append("\"").append(OAIUtil.xmlEncode((String)entry.getValue())).append("\"");
                }
            }
            this.record.append(">");
        } else {
            int i = 0;
            while (i < length) {
                String aEName = attrs.getQName(i);
                if (aEName.startsWith("xmlns:")) {
                    this.xmlnsMap.put(aEName, attrs.getValue(i));
                }
                ++i;
            }
            super.startElement(namespaceURI, localName, qName, attrs);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (this.recordCapture) {
            this.record.append("</");
            this.record.append(qName);
            this.record.append(">");
        } else {
            super.endElement(namespaceURI, localName, qName);
        }
        if (fullName.equals(HarvesterVerb.OAI20_RECORD)) {
            try {
                this.records.add(new Record(this.record.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SAXException(e.getMessage());
            }
            this.recordCapture = false;
        }
    }

    public void characters(char[] buf, int offset, int len) {
        if (this.recordCapture) {
            this.record.append(OAIUtil.xmlEncode(new String(buf, offset, len)));
        } else {
            super.characters(buf, offset, len);
        }
    }
}

