/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.harvester.verb.HarvesterVerb;
import ORG.oclc.oai.harvester.verb.StupidJavaBugException;
import ORG.oclc.oai.util.OAIUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ListSets
extends HarvesterVerb {
    private static final boolean debug = false;
    private boolean resumptionTokenCapture = false;
    private StringBuffer resumptionToken = new StringBuffer();
    private boolean setCapture = false;
    private StringBuffer set;
    private ArrayList sets = new ArrayList();

    public ListSets(URL baseURL) throws MalformedURLException, SAXException, IOException, StupidJavaBugException {
        StringBuffer sb = new StringBuffer();
        sb.append(baseURL.toString());
        sb.append("?");
        sb.append(ListSets.getQuery());
        XMLReader xmlReader = this.getXMLReader();
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(this.getResponseStream(sb.toString())));
        }
        catch (SAXException e) {
            System.out.println("HarvesterVerb.HarvesterVerb: query=" + sb.toString());
            e.printStackTrace();
            throw e;
        }
    }

    public ListSets(URL baseURL, String resumptionToken) throws MalformedURLException, SAXException, IOException {
        StringBuffer query = new StringBuffer();
        query.append(baseURL.toString());
        query.append("?");
        query.append(ListSets.getParams(resumptionToken));
        XMLReader xmlReader = this.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.parse(new InputSource(this.getResponseStream(query.toString())));
    }

    private static String getParams(String resumptionToken) throws IOException {
        try {
            StringBuffer query = new StringBuffer();
            query.append("verb=ListSets");
            query.append("&resumptionToken=");
            query.append(URLEncoder.encode(resumptionToken, "UTF-8"));
            return query.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    private static String getQuery() {
        StringBuffer query = new StringBuffer();
        query.append("verb=ListSets");
        return query.toString();
    }

    public List getSets() {
        if (this.sets.size() > 0) {
            return this.sets;
        }
        return null;
    }

    public String getResumptionToken() {
        if (this.resumptionToken.length() == 0) {
            return null;
        }
        return this.resumptionToken.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("resumptionToken: ");
        sb.append(this.resumptionToken);
        sb.append("\n");
        sb.append(super.toString());
        return sb.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (!this.setCapture && fullName.equals(HarvesterVerb.OAI20_SET)) {
            this.set = new StringBuffer();
            this.setCapture = true;
        }
        if (this.setCapture) {
            this.set.append("<");
            this.set.append(qName);
            int length = attrs.getLength();
            int i = 0;
            while (i < length) {
                this.set.append(" ");
                String aEName = attrs.getQName(i);
                this.set.append(aEName);
                this.set.append("=\"");
                this.set.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.set.append("\"");
                ++i;
            }
            this.set.append(">");
        } else if (fullName.equals(HarvesterVerb.OAI20_RESUMPTION_TOKEN)) {
            this.resumptionTokenCapture = true;
        } else {
            super.startElement(namespaceURI, localName, qName, attrs);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (this.setCapture) {
            this.set.append("</");
            this.set.append(qName);
            this.set.append(">");
        } else if (!this.resumptionTokenCapture) {
            super.endElement(namespaceURI, localName, qName);
        }
        if (fullName.equals(HarvesterVerb.OAI20_SET)) {
            this.sets.add(this.set.toString());
            this.setCapture = false;
        } else if (fullName.equals(HarvesterVerb.OAI20_RESUMPTION_TOKEN)) {
            this.resumptionTokenCapture = false;
        }
    }

    public void characters(char[] buf, int offset, int len) {
        if (this.resumptionTokenCapture) {
            this.resumptionToken.append(new String(buf, offset, len));
        } else if (this.setCapture) {
            this.set.append(OAIUtil.xmlEncode(new String(buf, offset, len)));
        } else {
            super.characters(buf, offset, len);
        }
    }
}

