/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.harvester.verb.HarvesterVerb;
import ORG.oclc.oai.util.OAIUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Record
extends DefaultHandler {
    private static final boolean debug = false;
    private static HashMap xmlReaders = new HashMap();
    private String record = null;
    private boolean identifierCapture = false;
    private StringBuffer identifier = new StringBuffer();
    private boolean datestampCapture = false;
    private StringBuffer datestamp = new StringBuffer();
    private boolean setSpecCapture = false;
    private ArrayList setSpecs = new ArrayList();
    private StringBuffer setSpec;
    private String status = null;
    private boolean metadataCapture = false;
    private StringBuffer metadata = new StringBuffer();
    private boolean aboutCapture = false;
    private ArrayList abouts = new ArrayList();
    private StringBuffer about = new StringBuffer();
    private HashMap xmlnsMap = new HashMap();

    private XMLReader getXMLReader() throws SAXException {
        Thread currentThread = Thread.currentThread();
        XMLReader xmlReader = (XMLReader)xmlReaders.get(currentThread);
        if (xmlReader == null) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException e) {
                try {
                    xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException e1) {
                    try {
                        xmlReader = XMLReaderFactory.createXMLReader("com.bluecase.xml.Piccolo");
                    }
                    catch (SAXException e2) {
                        try {
                            xmlReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                        }
                        catch (SAXException e3) {
                            try {
                                xmlReader = XMLReaderFactory.createXMLReader();
                            }
                            catch (SAXException e4) {
                                throw new SAXException("No SAX parser available");
                            }
                        }
                    }
                }
            }
            xmlReaders.put(currentThread, xmlReader);
        }
        return xmlReader;
    }

    public Record(String record) throws SAXException, IOException {
        this.record = record;
        XMLReader xmlReader = this.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(new StringReader(record)));
        }
        catch (SAXException e) {
            System.out.println("Record.Record: record=" + record);
            e.printStackTrace();
            throw e;
        }
    }

    public String getRecordXML() {
        return this.record;
    }

    public boolean isDeleted() {
        return "deleted".equals(this.status);
    }

    public String getIdentifier() {
        return this.identifier.toString();
    }

    public String getDatestamp() {
        return this.datestamp.toString();
    }

    public Iterator getSetSpecs() {
        if (this.setSpecs.size() > 0) {
            return this.setSpecs.iterator();
        }
        return null;
    }

    public String getMetadata() {
        if (this.metadata.length() > 0) {
            return this.metadata.toString();
        }
        return null;
    }

    public Iterator getAbouts() {
        if (this.about.length() > 0) {
            return this.abouts.iterator();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Record.identifier=");
        sb.append(this.getIdentifier());
        sb.append("\nRecord.datestamp=");
        sb.append(this.getDatestamp());
        Iterator setSpecs = this.getSetSpecs();
        if (setSpecs != null) {
            while (setSpecs.hasNext()) {
                sb.append("\nRecord.setSpec=");
                sb.append((String)setSpecs.next());
            }
        }
        sb.append("\nRecord.status=");
        sb.append(this.status);
        sb.append("\nRecord.metadata=");
        sb.append(this.getMetadata());
        Iterator abouts = this.getAbouts();
        if (abouts != null) {
            while (abouts.hasNext()) {
                sb.append("\nRecord.about=");
                sb.append((String)abouts.next());
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        int length = attrs.getLength();
        if (!this.metadataCapture && fullName.equals("#metadata")) {
            this.metadata.setLength(0);
            this.metadataCapture = true;
            this.addXmlns(attrs, this.xmlnsMap);
        } else if (!this.metadataCapture && !this.aboutCapture && fullName.equals("#about")) {
            this.about.setLength(0);
            this.aboutCapture = true;
            this.addXmlns(attrs, this.xmlnsMap);
        } else if (this.metadataCapture) {
            this.metadata.append("<");
            this.metadata.append(qName);
            HashMap tempMap = new HashMap();
            tempMap.putAll(this.xmlnsMap);
            int i = 0;
            while (i < length) {
                this.metadata.append(" ");
                String aEName = attrs.getQName(i);
                this.metadata.append(aEName);
                this.metadata.append("=\"");
                this.metadata.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.metadata.append("\"");
                tempMap.remove(aEName);
                ++i;
            }
            Iterator iter = tempMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String aEName = (String)entry.getKey();
                this.metadata.append(" ").append(aEName).append("=\"").append(entry.getValue()).append("\"");
            }
            this.metadata.append(">");
        } else if (this.aboutCapture) {
            this.about.append("<");
            this.about.append(qName);
            HashMap tempMap = new HashMap();
            tempMap.putAll(this.xmlnsMap);
            int i = 0;
            while (i < length) {
                this.about.append(" ");
                String aEName = attrs.getQName(i);
                this.about.append(aEName);
                this.about.append("=\"");
                this.about.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.about.append("\"");
                tempMap.remove(aEName);
                ++i;
            }
            Iterator iter = tempMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String aEName = (String)entry.getKey();
                this.about.append(" ").append(aEName).append("=\"").append(entry.getValue()).append("\"");
            }
            this.about.append(">");
        } else if (fullName.equals("#identifier")) {
            this.identifierCapture = true;
        } else if (fullName.equals("#datestamp")) {
            this.datestampCapture = true;
        } else if (fullName.equals("#setSpec")) {
            this.setSpecCapture = true;
            this.setSpec = new StringBuffer();
        } else if (fullName.equals("#record")) {
            this.addXmlns(attrs, this.xmlnsMap);
        } else if (fullName.equals("#header")) {
            int i = 0;
            while (i < length) {
                String aEName = HarvesterVerb.fullName(attrs.getURI(i), attrs.getLocalName(i));
                if (HarvesterVerb.OAI20_STATUS.equals(aEName)) {
                    this.status = attrs.getValue(i);
                }
                ++i;
            }
        } else {
            System.out.println("Unrecognized element: " + qName);
        }
    }

    private void addXmlns(Attributes attrs, HashMap xmlnsMap) {
        int length = attrs.getLength();
        int i = 0;
        while (i < length) {
            String aEName = attrs.getQName(i);
            if (aEName.startsWith("xmlns:")) {
                xmlnsMap.put(aEName, attrs.getValue(i));
            }
            ++i;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (fullName.equals("#metadata")) {
            this.metadataCapture = false;
        } else if (fullName.equals("#about")) {
            this.aboutCapture = false;
        }
        if (this.metadataCapture) {
            this.metadata.append("</");
            this.metadata.append(qName);
            this.metadata.append(">");
        } else if (this.aboutCapture) {
            this.about.append("</");
            this.about.append(qName);
            this.about.append(">");
        } else if (this.identifierCapture || this.datestampCapture || this.setSpecCapture) {
            // empty if block
        }
        if (fullName.equals("#about")) {
            this.aboutCapture = false;
            this.abouts.add(this.about.toString());
        } else if (fullName.equals("#identifier")) {
            this.identifierCapture = false;
        } else if (fullName.equals("#datestamp")) {
            this.datestampCapture = false;
        } else if (fullName.equals("#setSpec")) {
            this.setSpecs.add(this.setSpec.toString());
            this.setSpecCapture = false;
        }
    }

    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.identifierCapture) {
            this.identifier.append(OAIUtil.xmlEncode(s));
        } else if (this.datestampCapture) {
            this.datestamp.append(OAIUtil.xmlEncode(s));
        } else if (this.setSpecCapture) {
            this.setSpec.append(OAIUtil.xmlEncode(s));
        } else if (this.metadataCapture) {
            this.metadata.append(OAIUtil.xmlEncode(s));
        } else if (this.aboutCapture) {
            this.about.append(OAIUtil.xmlEncode(s));
        } else if (s.trim().length() > 0) {
            System.out.println("Unrecognized content:" + s);
        }
    }
}

