/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.CloseableIterationBase;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIteration<E, X extends Exception>
extends CloseableIterationBase<E, X> {
    private final AtomicReference<E> value;

    public SingletonIteration(E value) {
        this.value = new AtomicReference<E>(value);
    }

    @Override
    public boolean hasNext() {
        return this.value.get() != null;
    }

    @Override
    public E next() {
        E result = this.value.getAndSet(null);
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        this.value.set(null);
    }
}

