/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeftJoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private EvaluationStrategy strategy;
    private final LeftJoin join;
    private final Set<String> scopeBindingNames;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;

    public LeftJoinIterator(EvaluationStrategy strategy, LeftJoin join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.scopeBindingNames = join.getBindingNames();
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = new EmptyIteration<BindingSet, QueryEvaluationException>();
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            while (this.rightIter.hasNext() || this.leftIter.hasNext()) {
                BindingSet leftBindings = null;
                if (!this.rightIter.hasNext()) {
                    leftBindings = (BindingSet)this.leftIter.next();
                    this.rightIter.close();
                    this.rightIter = this.strategy.evaluate(this.join.getRightArg(), leftBindings);
                }
                while (this.rightIter.hasNext()) {
                    BindingSet rightBindings = (BindingSet)this.rightIter.next();
                    try {
                        if (this.join.getCondition() == null) {
                            return rightBindings;
                        }
                        QueryBindingSet scopeBindings = new QueryBindingSet(rightBindings);
                        scopeBindings.retainAll(this.scopeBindingNames);
                        if (!this.strategy.isTrue(this.join.getCondition(), scopeBindings)) continue;
                        return rightBindings;
                    }
                    catch (ValueExprEvaluationException valueExprEvaluationException) {
                    }
                }
                if (leftBindings == null) continue;
                return leftBindings;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        super.handleClose();
        this.leftIter.close();
        this.rightIter.close();
    }
}

