/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.io.ByteArrayUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.openrdf.sail.SailException;
import org.openrdf.sail.nativerdf.RecordCache;
import org.openrdf.sail.nativerdf.SequentialRecordCache;
import org.openrdf.sail.nativerdf.SortedRecordCache;
import org.openrdf.sail.nativerdf.btree.BTree;
import org.openrdf.sail.nativerdf.btree.RecordComparator;
import org.openrdf.sail.nativerdf.btree.RecordIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TripleStore {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_INDEXES = "spoc,posc";
    private static final String PROPERTIES_FILE = "triples.prop";
    private static final String VERSION_KEY = "version";
    private static final String INDEXES_KEY = "triple-indexes";
    private static final int SCHEME_VERSION = 10;
    static final int RECORD_LENGTH = 17;
    static final int SUBJ_IDX = 0;
    static final int PRED_IDX = 4;
    static final int OBJ_IDX = 8;
    static final int CONTEXT_IDX = 12;
    static final int FLAG_IDX = 16;
    static final byte EXPLICIT_FLAG = 1;
    static final byte ADDED_FLAG = 2;
    static final byte REMOVED_FLAG = 4;
    static final byte TOGGLE_EXPLICIT_FLAG = 8;
    private File dir;
    private Properties properties;
    private TripleIndex[] indexes;
    private boolean forceSync;
    private boolean txnAddedTriples = false;
    private boolean txnRemovedTriples = false;
    private RecordCache updatedTriplesCache;

    public TripleStore(File dir, String indexSpecStr) throws IOException, SailException {
        this(dir, indexSpecStr, false);
    }

    public TripleStore(File dir, String indexSpecStr, boolean forceSync) throws IOException, SailException {
        Set<String> indexSpecs;
        this.dir = dir;
        this.forceSync = forceSync;
        this.properties = new Properties();
        File propFile = new File(dir, PROPERTIES_FILE);
        if (propFile.exists()) {
            this.loadProperties(propFile);
            String versionStr = this.properties.getProperty(VERSION_KEY);
            if (versionStr == null) {
                this.logger.warn("version missing in TripleStore's properties file");
            } else {
                try {
                    int version = Integer.parseInt(versionStr);
                    if (version < 10) {
                        throw new SailException("Directory contains incompatible triple data");
                    }
                    if (version > 10) {
                        throw new SailException("Directory contains data that uses a newer data format");
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.warn("Malformed version number in TripleStore's properties file");
                }
            }
        }
        if ((indexSpecs = this.parseIndexSpecList(indexSpecStr)).isEmpty()) {
            indexSpecStr = this.getCurrentIndexSpecStr();
            indexSpecs = this.parseIndexSpecList(indexSpecStr);
            if (indexSpecs.size() > 0) {
                this.logger.info("No indexes specified, using existing indexes: {}", (Object)indexSpecStr);
            } else {
                indexSpecStr = DEFAULT_INDEXES;
                indexSpecs = this.parseIndexSpecList(indexSpecStr);
                this.logger.info("No indexes specified or found, defaulting to indexes: {}", (Object)indexSpecStr);
            }
        }
        this.reindex(indexSpecs);
        if (!String.valueOf(10).equals(this.properties.getProperty(VERSION_KEY)) || !indexSpecStr.equals(this.getCurrentIndexSpecStr())) {
            this.properties.setProperty(VERSION_KEY, String.valueOf(10));
            this.properties.setProperty(INDEXES_KEY, indexSpecStr);
            this.storeProperties(propFile);
        }
        this.indexes = new TripleIndex[indexSpecs.size()];
        int i = 0;
        for (String fieldSeq : indexSpecs) {
            this.logger.debug("Activating index '" + fieldSeq + "'...");
            this.indexes[i++] = new TripleIndex(fieldSeq);
        }
    }

    private Set<String> parseIndexSpecList(String indexSpecStr) throws SailException {
        HashSet<String> indexes = new HashSet<String>();
        if (indexSpecStr != null) {
            StringTokenizer tok = new StringTokenizer(indexSpecStr, ", \t");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken().toLowerCase();
                if (index.length() != 4 || index.indexOf(115) == -1 || index.indexOf(112) == -1 || index.indexOf(111) == -1 || index.indexOf(99) == -1) {
                    throw new SailException("invalid value '" + index + "' in index specification: " + indexSpecStr);
                }
                indexes.add(index);
            }
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex(Set<String> newIndexSpecs) throws IOException, SailException {
        String currentIndexSpecStr = this.getCurrentIndexSpecStr();
        if (currentIndexSpecStr == null) {
            return;
        }
        Set<String> currentIndexSpecs = this.parseIndexSpecList(currentIndexSpecStr);
        if (currentIndexSpecs.isEmpty()) {
            throw new SailException("Invalid index specification found in index properties");
        }
        HashSet<String> addedIndexSpecs = new HashSet<String>(newIndexSpecs);
        addedIndexSpecs.removeAll(currentIndexSpecs);
        if (!addedIndexSpecs.isEmpty()) {
            String sourceIndexSpec = currentIndexSpecs.iterator().next();
            TripleIndex sourceIndex = new TripleIndex(sourceIndexSpec);
            try {
                for (String fieldSeq : addedIndexSpecs) {
                    this.logger.debug("Initializing new index '" + fieldSeq + "'...");
                    TripleIndex addedIndex = new TripleIndex(fieldSeq);
                    BTree addedBTree = addedIndex.getBTree();
                    RecordIterator sourceIter = sourceIndex.getBTree().iterateAll();
                    try {
                        byte[] value = null;
                        while ((value = sourceIter.next()) != null) {
                            addedBTree.insert(value);
                        }
                    }
                    finally {
                        sourceIter.close();
                    }
                    addedBTree.close();
                }
                this.logger.debug("New index(es) initialized");
            }
            finally {
                sourceIndex.getBTree().close();
            }
        }
        HashSet<String> removedIndexSpecs = new HashSet<String>(currentIndexSpecs);
        removedIndexSpecs.removeAll(newIndexSpecs);
        for (String fieldSeq : removedIndexSpecs) {
            TripleIndex removedIndex = new TripleIndex(fieldSeq);
            boolean deleted = removedIndex.getBTree().delete();
            if (deleted) {
                this.logger.debug("Deleted file(s) for removed {} index", (Object)fieldSeq);
                continue;
            }
            this.logger.warn("Unable to delete file(s) for removed {} index", (Object)fieldSeq);
        }
    }

    private String getCurrentIndexSpecStr() {
        return this.properties.getProperty(INDEXES_KEY);
    }

    public void close() throws IOException {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i].getBTree().close();
        }
        this.indexes = null;
    }

    public RecordIterator getTriples(int subj, int pred, int obj, int context) throws IOException {
        return this.getTriples(subj, pred, obj, context, 0, 2);
    }

    public RecordIterator getTriples(int subj, int pred, int obj, int context, boolean readTransaction) throws IOException {
        if (readTransaction) {
            return this.getTriples(subj, pred, obj, context, 0, 4);
        }
        return this.getTriples(subj, pred, obj, context, 0, 2);
    }

    public RecordIterator getAllTriplesSortedByContext(boolean readTransaction) throws IOException {
        if (readTransaction) {
            return this.getAllTriplesSortedByContext(0, 4);
        }
        return this.getAllTriplesSortedByContext(0, 2);
    }

    public RecordIterator getTriples(int subj, int pred, int obj, int context, boolean explicit, boolean readTransaction) throws IOException {
        int flags = 0;
        int flagsMask = 0;
        if (readTransaction) {
            flagsMask |= 4;
        } else {
            flagsMask |= 2;
            if (explicit) {
                flags |= 1;
                flagsMask |= 1;
            }
        }
        RecordIterator btreeIter = this.getTriples(subj, pred, obj, context, flags, flagsMask);
        if (readTransaction && explicit) {
            btreeIter = new ExplicitStatementFilter(btreeIter);
        }
        return btreeIter;
    }

    private RecordIterator getTriples(int subj, int pred, int obj, int context, int flags, int flagsMask) throws IOException {
        TripleIndex index = this.getBestIndex(subj, pred, obj, context);
        boolean doRangeSearch = index.getPatternScore(subj, pred, obj, context) > 0;
        return this.getTriplesUsingIndex(subj, pred, obj, context, flags, flagsMask, index, doRangeSearch);
    }

    private RecordIterator getAllTriplesSortedByContext(int flags, int flagsMask) throws IOException {
        for (TripleIndex index : this.indexes) {
            if (index.getFieldSeq()[0] != 'c') continue;
            return this.getTriplesUsingIndex(-1, -1, -1, -1, flags, flagsMask, index, false);
        }
        return null;
    }

    private RecordIterator getTriplesUsingIndex(int subj, int pred, int obj, int context, int flags, int flagsMask, TripleIndex index, boolean rangeSearch) {
        byte[] searchKey = this.getSearchKey(subj, pred, obj, context, flags);
        byte[] searchMask = this.getSearchMask(subj, pred, obj, context, flagsMask);
        if (rangeSearch) {
            byte[] minValue = this.getMinValue(subj, pred, obj, context);
            byte[] maxValue = this.getMaxValue(subj, pred, obj, context);
            return index.getBTree().iterateRangedValues(searchKey, searchMask, minValue, maxValue);
        }
        return index.getBTree().iterateValues(searchKey, searchMask);
    }

    protected double cardinality(int subj, int pred, int obj, int context) throws IOException {
        double rangeSize;
        TripleIndex index = this.getBestIndex(subj, pred, obj, context);
        BTree btree = index.btree;
        if (index.getPatternScore(subj, pred, obj, context) == 0) {
            rangeSize = btree.getValueCountEstimate();
        } else {
            byte[] minValue = this.getMinValue(subj, pred, obj, context);
            byte[] maxValue = this.getMaxValue(subj, pred, obj, context);
            rangeSize = btree.getValueCountEstimate(minValue, maxValue);
        }
        return rangeSize;
    }

    protected TripleIndex getBestIndex(int subj, int pred, int obj, int context) {
        int bestScore = -1;
        TripleIndex bestIndex = null;
        for (TripleIndex index : this.indexes) {
            int score = index.getPatternScore(subj, pred, obj, context);
            if (score <= bestScore) continue;
            bestScore = score;
            bestIndex = index;
        }
        return bestIndex;
    }

    public void clear() throws IOException {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i].getBTree().clear();
        }
    }

    public boolean storeTriple(int subj, int pred, int obj, int context) throws IOException {
        return this.storeTriple(subj, pred, obj, context, true);
    }

    public boolean storeTriple(int subj, int pred, int obj, int context, boolean explicit) throws IOException {
        boolean result = false;
        byte[] data = this.getData(subj, pred, obj, context, 0);
        byte[] storedData = this.indexes[0].getBTree().get(data);
        if (storedData == null) {
            data[16] = (byte)(data[16] | 2);
            if (explicit) {
                data[16] = (byte)(data[16] | 1);
            }
            result = true;
            this.txnAddedTriples = true;
        } else {
            boolean toggled;
            byte flags = storedData[16];
            boolean isExplicit = (flags & 1) != 0;
            boolean added = (flags & 2) != 0;
            boolean removed = (flags & 4) != 0;
            boolean bl = toggled = (flags & 8) != 0;
            if (added) {
                data[16] = (byte)(data[16] | 2);
                if (explicit || isExplicit) {
                    data[16] = (byte)(data[16] | 1);
                }
            } else {
                if (isExplicit) {
                    data[16] = (byte)(data[16] | 1);
                }
                if (explicit) {
                    if (!isExplicit) {
                        data[16] = (byte)(data[16] | 8);
                    }
                } else if (removed) {
                    if (isExplicit) {
                        data[16] = (byte)(data[16] | 8);
                    }
                } else if (toggled) {
                    data[16] = (byte)(data[16] | 8);
                }
            }
            result = removed;
        }
        if (storedData == null || !Arrays.equals(data, storedData)) {
            for (TripleIndex index : this.indexes) {
                index.getBTree().insert(data);
            }
            this.updatedTriplesCache.storeRecord(data);
        }
        return result;
    }

    public int removeTriples(int subj, int pred, int obj, int context) throws IOException {
        RecordIterator iter = this.getTriples(subj, pred, obj, context, 0, 0);
        return this.removeTriples(iter);
    }

    public int removeTriples(int subj, int pred, int obj, int context, boolean explicit) throws IOException {
        int flags = explicit ? 1 : 0;
        RecordIterator iter = this.getTriples(subj, pred, obj, context, flags, 1);
        return this.removeTriples(iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeTriples(RecordIterator iter) throws IOException {
        byte[] data = iter.next();
        if (data == null) {
            return 0;
        }
        int count = 0;
        SequentialRecordCache removedTriplesCache = new SequentialRecordCache(this.dir, 17);
        try {
            while (data != null) {
                if ((data[16] & 4) == 0) {
                    data[16] = (byte)(data[16] | 4);
                    removedTriplesCache.storeRecord(data);
                }
                data = iter.next();
            }
            iter.close();
            count = (int)removedTriplesCache.getRecordCount();
            this.updatedTriplesCache.storeRecords(removedTriplesCache);
            for (TripleIndex index : this.indexes) {
                BTree btree = index.getBTree();
                RecordIterator recIter = removedTriplesCache.getRecords();
                try {
                    while ((data = recIter.next()) != null) {
                        btree.insert(data);
                    }
                }
                finally {
                    recIter.close();
                }
            }
        }
        finally {
            ((RecordCache)removedTriplesCache).discard();
        }
        if (count > 0) {
            this.txnRemovedTriples = true;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardTriples(RecordIterator iter) throws IOException {
        byte[] data = iter.next();
        if (data == null) {
            return;
        }
        SequentialRecordCache recordCache = new SequentialRecordCache(this.dir, 17);
        try {
            while (data != null) {
                recordCache.storeRecord(data);
                data = iter.next();
            }
            iter.close();
            for (TripleIndex index : this.indexes) {
                BTree btree = index.getBTree();
                RecordIterator recIter = recordCache.getRecords();
                try {
                    while ((data = recIter.next()) != null) {
                        btree.remove(data);
                    }
                }
                finally {
                    recIter.close();
                }
            }
        }
        finally {
            ((RecordCache)recordCache).discard();
        }
    }

    public void startTransaction() throws IOException {
        long maxRecords = this.indexes[0].getBTree().getValueCountEstimate() / 10L;
        this.updatedTriplesCache = new SortedRecordCache(this.dir, 17, maxRecords, new TripleComparator("spoc"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (this.txnRemovedTriples) {
            RecordIterator iter = this.getTriples(-1, -1, -1, -1, 4, 4);
            try {
                this.discardTriples(iter);
            }
            finally {
                this.txnRemovedTriples = false;
                iter.close();
            }
        }
        boolean validCache = this.updatedTriplesCache.isValid();
        for (TripleIndex index : this.indexes) {
            BTree btree = index.getBTree();
            RecordIterator iter = validCache ? this.updatedTriplesCache.getRecords() : btree.iterateAll();
            try {
                byte[] data = null;
                while ((data = iter.next()) != null) {
                    boolean toggled;
                    byte flags = data[16];
                    boolean added = (flags & 2) != 0;
                    boolean removed = (flags & 4) != 0;
                    boolean bl = toggled = (flags & 8) != 0;
                    if (removed || !added && !toggled) continue;
                    if (toggled) {
                        data[16] = (byte)(data[16] ^ 1);
                    }
                    if (added) {
                        data[16] = (byte)(data[16] ^ 2);
                    }
                    if (validCache) {
                        btree.insert(data);
                        continue;
                    }
                    iter.set(data);
                }
            }
            finally {
                iter.close();
            }
        }
        this.updatedTriplesCache.discard();
        this.updatedTriplesCache = null;
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        if (this.txnAddedTriples) {
            RecordIterator iter = this.getTriples(-1, -1, -1, -1, 2, 2);
            try {
                this.discardTriples(iter);
            }
            finally {
                this.txnAddedTriples = false;
                iter.close();
            }
        }
        boolean validCache = this.updatedTriplesCache.isValid();
        int txnFlagsMask = -15;
        for (TripleIndex index : this.indexes) {
            BTree btree = index.getBTree();
            RecordIterator iter = validCache ? this.updatedTriplesCache.getRecords() : btree.iterateAll();
            try {
                byte[] data = null;
                while ((data = iter.next()) != null) {
                    boolean toggled;
                    byte flags = data[16];
                    boolean removed = (flags & 4) != 0;
                    boolean bl = toggled = (flags & 8) != 0;
                    if (!removed && !toggled) continue;
                    data[16] = (byte)(data[16] & txnFlagsMask);
                    if (validCache) {
                        btree.insert(data);
                        continue;
                    }
                    iter.set(data);
                }
            }
            finally {
                iter.close();
            }
        }
        this.updatedTriplesCache.discard();
        this.updatedTriplesCache = null;
        this.sync();
    }

    protected void sync() throws IOException {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i].getBTree().sync();
        }
    }

    private byte[] getData(int subj, int pred, int obj, int context, int flags) {
        byte[] data = new byte[17];
        ByteArrayUtil.putInt(subj, data, 0);
        ByteArrayUtil.putInt(pred, data, 4);
        ByteArrayUtil.putInt(obj, data, 8);
        ByteArrayUtil.putInt(context, data, 12);
        data[16] = (byte)flags;
        return data;
    }

    private byte[] getSearchKey(int subj, int pred, int obj, int context, int flags) {
        return this.getData(subj, pred, obj, context, flags);
    }

    private byte[] getSearchMask(int subj, int pred, int obj, int context, int flags) {
        byte[] mask = new byte[17];
        if (subj != -1) {
            ByteArrayUtil.putInt(-1, mask, 0);
        }
        if (pred != -1) {
            ByteArrayUtil.putInt(-1, mask, 4);
        }
        if (obj != -1) {
            ByteArrayUtil.putInt(-1, mask, 8);
        }
        if (context != -1) {
            ByteArrayUtil.putInt(-1, mask, 12);
        }
        mask[16] = (byte)flags;
        return mask;
    }

    private byte[] getMinValue(int subj, int pred, int obj, int context) {
        byte[] minValue = new byte[17];
        ByteArrayUtil.putInt(subj == -1 ? 0 : subj, minValue, 0);
        ByteArrayUtil.putInt(pred == -1 ? 0 : pred, minValue, 4);
        ByteArrayUtil.putInt(obj == -1 ? 0 : obj, minValue, 8);
        ByteArrayUtil.putInt(context == -1 ? 0 : context, minValue, 12);
        minValue[16] = 0;
        return minValue;
    }

    private byte[] getMaxValue(int subj, int pred, int obj, int context) {
        byte[] maxValue = new byte[17];
        ByteArrayUtil.putInt(subj == -1 ? -1 : subj, maxValue, 0);
        ByteArrayUtil.putInt(pred == -1 ? -1 : pred, maxValue, 4);
        ByteArrayUtil.putInt(obj == -1 ? -1 : obj, maxValue, 8);
        ByteArrayUtil.putInt(context == -1 ? -1 : context, maxValue, 12);
        maxValue[16] = -1;
        return maxValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(File propFile) throws IOException {
        FileInputStream in = new FileInputStream(propFile);
        try {
            this.properties.clear();
            this.properties.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProperties(File propFile) throws IOException {
        FileOutputStream out = new FileOutputStream(propFile);
        try {
            this.properties.store(out, "triple indexes meta-data, DO NOT EDIT!");
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private static class TripleComparator
    implements RecordComparator {
        private char[] fieldSeq;

        public TripleComparator(String fieldSeq) {
            this.fieldSeq = fieldSeq.toCharArray();
        }

        public char[] getFieldSeq() {
            return this.fieldSeq;
        }

        public final int compareBTreeValues(byte[] key, byte[] data, int offset, int length) {
            for (char field : this.fieldSeq) {
                int fieldIdx = 0;
                switch (field) {
                    case 's': {
                        fieldIdx = 0;
                        break;
                    }
                    case 'p': {
                        fieldIdx = 4;
                        break;
                    }
                    case 'o': {
                        fieldIdx = 8;
                        break;
                    }
                    case 'c': {
                        fieldIdx = 12;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid character '" + field + "' in field sequence: " + new String(this.fieldSeq));
                    }
                }
                int diff = ByteArrayUtil.compareRegion(key, fieldIdx, data, offset + fieldIdx, 4);
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }

    private class TripleIndex {
        private TripleComparator tripleComparator;
        private BTree btree;

        public TripleIndex(String fieldSeq) throws IOException {
            this.tripleComparator = new TripleComparator(fieldSeq);
            this.btree = new BTree(TripleStore.this.dir, this.getFilenamePrefix(fieldSeq), 2048, 17, this.tripleComparator, TripleStore.this.forceSync);
        }

        private String getFilenamePrefix(String fieldSeq) {
            return "triples-" + fieldSeq;
        }

        public char[] getFieldSeq() {
            return this.tripleComparator.getFieldSeq();
        }

        public File getFile() {
            return this.btree.getFile();
        }

        public BTree getBTree() {
            return this.btree;
        }

        public int getPatternScore(int subj, int pred, int obj, int context) {
            int score = 0;
            block6: for (char field : this.tripleComparator.getFieldSeq()) {
                switch (field) {
                    case 's': {
                        if (subj >= 0) {
                            ++score;
                            continue block6;
                        }
                        return score;
                    }
                    case 'p': {
                        if (pred >= 0) {
                            ++score;
                            continue block6;
                        }
                        return score;
                    }
                    case 'o': {
                        if (obj >= 0) {
                            ++score;
                            continue block6;
                        }
                        return score;
                    }
                    case 'c': {
                        if (context >= 0) {
                            ++score;
                            continue block6;
                        }
                        return score;
                    }
                    default: {
                        throw new RuntimeException("invalid character '" + field + "' in field sequence: " + new String(this.tripleComparator.getFieldSeq()));
                    }
                }
            }
            return score;
        }
    }

    private static class ExplicitStatementFilter
    implements RecordIterator {
        private final RecordIterator wrappedIter;

        public ExplicitStatementFilter(RecordIterator wrappedIter) {
            this.wrappedIter = wrappedIter;
        }

        public byte[] next() throws IOException {
            boolean toggled;
            byte flags;
            boolean explicit;
            byte[] result;
            while ((result = this.wrappedIter.next()) != null && (explicit = ((flags = result[16]) & 1) != 0) == (toggled = (flags & 8) != 0)) {
            }
            return result;
        }

        public void set(byte[] value) throws IOException {
            this.wrappedIter.set(value);
        }

        public void close() throws IOException {
            this.wrappedIter.close();
        }
    }
}

