/*
 * Decompiled with CFR 0.152.
 */
package org.svenson;

import org.svenson.TypeMapper;
import org.svenson.tokenize.JSONTokenizer;
import org.svenson.tokenize.Token;
import org.svenson.tokenize.TokenType;

public abstract class AbstractTypeMapper
implements TypeMapper {
    protected void skipObjectValue(JSONTokenizer tokenizer) {
        this.skipComplexValue(tokenizer, TokenType.BRACE_OPEN, TokenType.BRACE_CLOSE);
    }

    protected void skipArrayValue(JSONTokenizer tokenizer) {
        this.skipComplexValue(tokenizer, TokenType.BRACKET_OPEN, TokenType.BRACKET_CLOSE);
    }

    private void skipComplexValue(JSONTokenizer tokenizer, TokenType open, TokenType close) {
        Token token;
        TokenType tokenType;
        int level = 1;
        while ((tokenType = (token = tokenizer.next()).type()) != TokenType.END) {
            if (tokenType == open) {
                ++level;
            } else if (tokenType == close) {
                --level;
            }
            if (level != 0) continue;
        }
        if (token.type() == TokenType.END) {
            throw new IllegalStateException("Unexpected end");
        }
    }

    protected Object getPropertyValueFromTokenStream(JSONTokenizer tokenizer, String propertyName, Token first) {
        Token token = first;
        do {
            token.expect(TokenType.STRING);
            String currentPropertyName = (String)token.value();
            tokenizer.expectNext(TokenType.COLON);
            Token firstValueToken = tokenizer.next();
            if (currentPropertyName.equals(propertyName)) {
                return firstValueToken.value();
            }
            if (firstValueToken.type() == TokenType.BRACE_OPEN) {
                this.skipObjectValue(tokenizer);
            } else if (firstValueToken.type() == TokenType.BRACKET_OPEN) {
                this.skipArrayValue(tokenizer);
            }
            Token next = tokenizer.expectNext(TokenType.COMMA, TokenType.BRACE_CLOSE);
            if (next.type() != TokenType.BRACE_CLOSE) continue;
            return null;
        } while ((token = tokenizer.next()).type() != TokenType.END);
        return null;
    }
}

