/*
 * Decompiled with CFR 0.152.
 */
package org.svenson;

import org.svenson.AbstractPropertyValueBasedTypeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameBasedTypeMapper
extends AbstractPropertyValueBasedTypeMapper {
    private String basePackage;
    private Class<?> enforcedBaseType;

    public void setEnforcedBaseType(Class<?> enforcedBaseType) {
        this.enforcedBaseType = enforcedBaseType;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    protected Class<Object> getTypeHintFromTypeProperty(Object o) throws IllegalStateException {
        if (o == null) {
            throw new IllegalArgumentException("class name can't be null");
        }
        String value = (String)o;
        if (this.basePackage != null) {
            value = this.basePackage + "." + value;
        }
        try {
            Class<Object> cls = Class.forName(value);
            if (this.enforcedBaseType != null && !this.enforcedBaseType.isAssignableFrom(cls)) {
                throw new IllegalStateException(cls + " is not assignable to " + this.enforcedBaseType);
            }
            Class<Object> objClass = cls;
            return objClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("No class found for property '" + value + "'", e);
        }
    }
}

