/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.info;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.svenson.JSONParseException;
import org.svenson.converter.TypeConverter;
import org.svenson.info.JSONPropertyInfo;
import org.svenson.util.ExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaObjectPropertyInfo
implements JSONPropertyInfo {
    private Method getterMethod;
    private Method setterMethod;
    private Method adderMethod;
    private boolean ignore;
    private boolean ignoreIfNull;
    private boolean readOnly;
    private String javaPropertyName;
    private Class<?> typeHint;
    private String jsonName;
    private String linkIdProperty;
    private TypeConverter typeConverter;

    public JavaObjectPropertyInfo(String javaPropertyName, Method getterMethod, Method setterMethod) {
        this.javaPropertyName = javaPropertyName;
        this.getterMethod = getterMethod;
        this.setterMethod = setterMethod;
    }

    Method getSetterMethod() {
        return this.setterMethod;
    }

    public void setSetterMethod(Method setterMethod) {
        this.setterMethod = setterMethod;
    }

    Method getGetterMethod() {
        return this.getterMethod;
    }

    public void setGetterMethod(Method getterMethod) {
        this.getterMethod = getterMethod;
    }

    @Override
    public boolean isIgnore() {
        return this.ignore;
    }

    @Override
    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    public boolean isIgnoreIfNull() {
        return this.ignoreIfNull;
    }

    @Override
    public void setIgnoreIfNull(boolean ignoreIfNull) {
        this.ignoreIfNull = ignoreIfNull;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public String getJavaPropertyName() {
        return this.javaPropertyName;
    }

    @Override
    public void setJavaPropertyName(String javaPropertyName) {
        this.javaPropertyName = javaPropertyName;
    }

    @Override
    public boolean isLinkedProperty() {
        return this.linkIdProperty != null;
    }

    @Override
    public String getLinkIdProperty() {
        return this.linkIdProperty;
    }

    @Override
    public void setLinkIdProperty(String linkIdProperty) {
        this.linkIdProperty = linkIdProperty;
    }

    @Override
    public Class<Object> getTypeOfProperty() {
        if (this.setterMethod != null) {
            return this.setterMethod.getParameterTypes()[0];
        }
        return null;
    }

    @Override
    public boolean isWriteable() {
        return this.setterMethod != null;
    }

    @Override
    public boolean isReadable() {
        return this.getterMethod != null;
    }

    @Override
    public Class<Object> getTypeHint() {
        return this.typeHint;
    }

    @Override
    public void setTypeHint(Class<?> typeHint) {
        this.typeHint = typeHint;
    }

    Method getAdderMethod() {
        return this.adderMethod;
    }

    public void setAdderMethod(Method adderMethod) {
        this.adderMethod = adderMethod;
    }

    @Override
    public String getJsonName() {
        return this.jsonName;
    }

    @Override
    public void setJsonName(String jsonName) {
        this.jsonName = jsonName;
    }

    @Override
    public Object getProperty(Object target) {
        if (this.getterMethod == null) {
            throw new JSONParseException("Property '" + this.getJavaPropertyName() + "' in " + target.getClass() + " is not readable.");
        }
        try {
            return this.getterMethod.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    @Override
    public void setProperty(Object target, Object value) {
        if (this.setterMethod == null) {
            throw new JSONParseException("Property '" + this.getJavaPropertyName() + "' in " + target.getClass() + " is not writable.");
        }
        try {
            this.setterMethod.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    public String toString() {
        return super.toString() + " adderMethod=" + this.adderMethod + ", getterMethod=" + this.getterMethod + ", ignore=" + this.ignore + ", ignoreIfNull=" + this.ignoreIfNull + ", javaPropertyName=" + this.javaPropertyName + ", jsonName=" + this.jsonName + ", linkIdProperty=" + this.linkIdProperty + ", readOnly=" + this.readOnly + ", setterMethod=" + this.setterMethod + ", typeHint=" + this.typeHint;
    }

    @Override
    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public boolean canAdd() {
        return this.adderMethod != null;
    }

    @Override
    public Class<Object> getAdderType() {
        Class<Object> adder = this.adderMethod.getParameterTypes()[0];
        return adder;
    }

    @Override
    public void add(Object target, Object value) {
        try {
            this.adderMethod.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionWrapper.wrap(e);
        }
        catch (InvocationTargetException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    @Override
    public Class<Object> getType() {
        Class<Object> type;
        if (this.getterMethod != null) {
            type = this.getterMethod.getReturnType();
        } else if (this.setterMethod != null) {
            type = this.setterMethod.getParameterTypes()[0];
        } else if (this.adderMethod != null) {
            type = this.adderMethod.getParameterTypes()[0];
        } else {
            throw new IllegalStateException("No method!?");
        }
        return type;
    }
}

