/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.info;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.svenson.JSONProperty;
import org.svenson.JSONReference;
import org.svenson.JSONTypeHint;
import org.svenson.converter.JSONConverter;
import org.svenson.converter.TypeConverter;
import org.svenson.converter.TypeConverterRepository;
import org.svenson.info.AbstractObjectSupport;
import org.svenson.info.JSONClassInfo;
import org.svenson.info.JavaObjectPropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaObjectSupport
extends AbstractObjectSupport {
    private static final String ADDER_PREFIX = "add";
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String ISSER_PREFIX = "is";
    private TypeConverterRepository typeConverterRepository;

    public JavaObjectSupport() {
        this(null);
    }

    public JavaObjectSupport(TypeConverterRepository typeConverterRepository) {
        this.typeConverterRepository = typeConverterRepository;
    }

    @Override
    public JSONClassInfo createClassInfo(Class<?> cls) {
        HashMap<String, JavaObjectPropertyInfo> javaNameToInfo = new HashMap<String, JavaObjectPropertyInfo>();
        for (Method m : cls.getMethods()) {
            JavaObjectPropertyInfo pair;
            String javaPropertyName;
            String name = m.getName();
            if ((m.getModifiers() & 1) == 0 || name.equals("getClass")) continue;
            if (name.startsWith(SETTER_PREFIX) && m.getParameterTypes().length == 1) {
                Class<?> paramType;
                javaPropertyName = JavaObjectSupport.propertyName(name, SETTER_PREFIX.length());
                pair = (JavaObjectPropertyInfo)javaNameToInfo.get(javaPropertyName);
                if (pair != null) {
                    pair.setSetterMethod(m);
                } else {
                    pair = new JavaObjectPropertyInfo(javaPropertyName, null, m);
                    javaNameToInfo.put(javaPropertyName, pair);
                }
                Class<?>[] parameterTypes = m.getParameterTypes();
                if (parameterTypes.length != 1 || !(paramType = parameterTypes[0]).isArray()) continue;
                pair.setTypeHint(paramType.getComponentType());
                continue;
            }
            if (m.getParameterTypes().length == 0 && !m.getReturnType().equals(Void.TYPE)) {
                if (name.startsWith(GETTER_PREFIX)) {
                    javaPropertyName = JavaObjectSupport.propertyName(name, GETTER_PREFIX.length());
                    pair = (JavaObjectPropertyInfo)javaNameToInfo.get(javaPropertyName);
                    if (pair != null) {
                        pair.setGetterMethod(m);
                        continue;
                    }
                    javaNameToInfo.put(javaPropertyName, new JavaObjectPropertyInfo(javaPropertyName, m, null));
                    continue;
                }
                if (!name.startsWith(ISSER_PREFIX)) continue;
                javaPropertyName = JavaObjectSupport.propertyName(name, ISSER_PREFIX.length());
                pair = (JavaObjectPropertyInfo)javaNameToInfo.get(javaPropertyName);
                if (pair != null) {
                    pair.setGetterMethod(m);
                    continue;
                }
                javaNameToInfo.put(javaPropertyName, new JavaObjectPropertyInfo(javaPropertyName, m, null));
                continue;
            }
            if (!name.startsWith(ADDER_PREFIX) || m.getParameterTypes().length != 1) continue;
            javaPropertyName = JavaObjectSupport.propertyName(name, ADDER_PREFIX.length());
            pair = (JavaObjectPropertyInfo)javaNameToInfo.get(javaPropertyName);
            if (pair != null) {
                pair.setAdderMethod(m);
                continue;
            }
            JavaObjectPropertyInfo newInfo = new JavaObjectPropertyInfo(javaPropertyName, null, null);
            newInfo.setAdderMethod(m);
            javaNameToInfo.put(javaPropertyName, newInfo);
        }
        HashMap<String, JavaObjectPropertyInfo> propertyInfos = new HashMap<String, JavaObjectPropertyInfo>(javaNameToInfo.size());
        for (Map.Entry e : javaNameToInfo.entrySet()) {
            JSONConverter converterAnno;
            JSONTypeHint typeHintAnno;
            Method setterMethod;
            String jsonPropertyName = (String)e.getKey();
            JavaObjectPropertyInfo propertyInfo = (JavaObjectPropertyInfo)e.getValue();
            Method getterMethod = propertyInfo.getGetterMethod();
            JSONProperty jsonProperty = JavaObjectSupport.getAnnotation(JSONProperty.class, getterMethod, setterMethod = propertyInfo.getSetterMethod());
            if (jsonProperty != null) {
                if (jsonProperty.value().length() > 0) {
                    jsonPropertyName = jsonProperty.value();
                }
                propertyInfo.setIgnore(jsonProperty.ignore());
                propertyInfo.setIgnoreIfNull(jsonProperty.ignoreIfNull());
                propertyInfo.setReadOnly(jsonProperty.readOnly());
            }
            propertyInfo.setJsonName(jsonPropertyName);
            JSONReference refAnno = JavaObjectSupport.getAnnotation(JSONReference.class, getterMethod, setterMethod);
            if (refAnno != null) {
                propertyInfo.setLinkIdProperty(refAnno.idProperty());
            }
            if ((typeHintAnno = JavaObjectSupport.getAnnotation(JSONTypeHint.class, getterMethod, setterMethod)) != null) {
                propertyInfo.setTypeHint(typeHintAnno.value());
            }
            if (this.typeConverterRepository != null && (converterAnno = JavaObjectSupport.getAnnotation(JSONConverter.class, getterMethod, setterMethod)) != null) {
                TypeConverter typeConverter = null;
                typeConverter = converterAnno.name().length() == 0 ? this.typeConverterRepository.getConverterByType(converterAnno.type()) : this.typeConverterRepository.getConverterById(converterAnno.name());
                propertyInfo.setTypeConverter(typeConverter);
            }
            propertyInfos.put(jsonPropertyName, propertyInfo);
        }
        return new JSONClassInfo(cls, propertyInfos);
    }
}

