/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.tokenize;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.svenson.tokenize.JSONCharacterSource;
import org.svenson.util.ExceptionWrapper;

public class InputStreamSource
implements JSONCharacterSource {
    private Reader reader;
    private int index;
    private boolean close;

    public InputStreamSource(InputStream inputStream, boolean close) {
        try {
            this.reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionWrapper.wrap(e);
        }
        this.close = close;
    }

    public int getIndex() {
        return this.index;
    }

    public int nextChar() {
        try {
            int result = this.reader.read();
            ++this.index;
            return (char)result;
        }
        catch (IOException e) {
            throw ExceptionWrapper.wrap(e);
        }
    }

    public void destroy() {
        if (this.close) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw ExceptionWrapper.wrap(e);
            }
        }
    }
}

