/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.tokenize;

import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TokenType {
    BRACE_OPEN("{"),
    BRACE_CLOSE("}"),
    COLON(":"),
    BRACKET_OPEN("["),
    BRACKET_CLOSE("]"),
    COMMA(","),
    STRING(String.class),
    INTEGER(Long.class),
    DECIMAL(BigDecimal.class),
    TRUE(Boolean.TRUE),
    FALSE(Boolean.FALSE),
    NULL(null),
    END(null);

    private Object validContent;

    private TokenType(Object validContent) {
        this.validContent = validContent;
    }

    public void checkValue(Object value) throws IllegalArgumentException {
        if (this.isClassRestricted()) {
            Class cls = (Class)this.validContent;
            if (!cls.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Values for " + this.name() + " must be a " + cls);
            }
        } else if (this.validContent == null) {
            if (value != null) {
                throw new IllegalArgumentException("Only null values allowed for " + this.name());
            }
        } else if (!this.validContent.equals(value)) {
            throw new IllegalArgumentException("Value for " + this.name() + " must be " + this.validContent);
        }
    }

    public boolean isClassRestricted() {
        return this.validContent instanceof Class;
    }

    public Object getValidContent() {
        return this.validContent;
    }

    public boolean isPrimitive() {
        switch (this) {
            case STRING: 
            case TRUE: 
            case FALSE: 
            case NULL: 
            case INTEGER: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }
}

