/*
 * Decompiled with CFR 0.152.
 */
package org.svenson.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.svenson.DynamicProperties;
import org.svenson.TypeAnalyzer;
import org.svenson.info.JSONPropertyInfo;
import org.svenson.info.JavaObjectSupport;
import org.svenson.info.ObjectSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONBeanUtil {
    private static final JSONBeanUtil defaultUtil = new JSONBeanUtil();
    private ObjectSupport objectSupport;

    public static JSONBeanUtil defaultUtil() {
        return defaultUtil;
    }

    public JSONBeanUtil() {
        this(new JavaObjectSupport());
    }

    public JSONBeanUtil(ObjectSupport objectSupport) {
        this.objectSupport = objectSupport;
    }

    public Set<String> getAllPropertyNames(Object bean) {
        HashSet<String> names = new HashSet<String>();
        if (bean instanceof DynamicProperties) {
            names.addAll(((DynamicProperties)bean).propertyNames());
        }
        if (bean instanceof Map) {
            names.addAll(((Map)bean).keySet());
        }
        names.addAll(this.getBeanPropertyNames(bean));
        return names;
    }

    public Set<String> getBeanPropertyNames(Object bean) {
        return TypeAnalyzer.getClassInfo(this.objectSupport, bean.getClass()).getPropertyNames();
    }

    public Object getProperty(Object bean, String name) throws IllegalArgumentException {
        if (bean instanceof Map) {
            return ((Map)bean).get(name);
        }
        JSONPropertyInfo propertyInfo = TypeAnalyzer.getClassInfo(this.objectSupport, bean.getClass()).getPropertyInfo(name);
        if (propertyInfo != null && propertyInfo.isReadable()) {
            return propertyInfo.getProperty(bean);
        }
        if (bean instanceof DynamicProperties) {
            return ((DynamicProperties)bean).getProperty(name);
        }
        throw new IllegalArgumentException(bean + " has no JSON property with the name '" + name + "' and does not implements DynamicProperties");
    }

    public void setProperty(Object bean, String name, Object value) throws IllegalArgumentException {
        if (bean instanceof Map) {
            ((Map)bean).put(name, value);
        } else {
            JSONPropertyInfo propertyInfo = TypeAnalyzer.getClassInfo(this.objectSupport, bean.getClass()).getPropertyInfo(name);
            if (propertyInfo != null && propertyInfo.isWriteable()) {
                propertyInfo.setProperty(bean, value);
            } else if (bean instanceof DynamicProperties) {
                ((DynamicProperties)bean).setProperty(name, value);
            } else {
                throw new IllegalArgumentException(bean + " has no JSON property with the name '" + name + "' and does not implements DynamicProperties");
            }
        }
    }
}

