/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.List;
import java.util.Properties;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLPrefix;
import org.z3950.zing.cql.Modifier;
import org.z3950.zing.cql.ModifierSet;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.XCQLBuilder;

public abstract class CQLBooleanNode
extends CQLNode {
    private CQLNode left;
    private CQLNode right;
    ModifierSet ms;

    public CQLNode getLeftOperand() {
        return this.left;
    }

    public CQLNode getRightOperand() {
        return this.right;
    }

    public List<Modifier> getModifiers() {
        return this.ms.getModifiers();
    }

    protected CQLBooleanNode(CQLNode left, CQLNode right, ModifierSet ms) {
        this.left = left;
        this.right = right;
        this.ms = ms;
    }

    @Override
    void toXCQLInternal(XCQLBuilder b, int level, List<CQLPrefix> prefixes, List<ModifierSet> sortkeys) {
        b.indent(level).append("<triple>\n");
        CQLBooleanNode.renderPrefixes(b, level + 1, prefixes);
        this.ms.toXCQLInternal(b, level + 1, "boolean", "value");
        b.indent(level + 1).append("<leftOperand>\n");
        this.left.toXCQLInternal(b, level + 2);
        b.indent(level + 1).append("</leftOperand>\n");
        b.indent(level + 1).append("<rightOperand>\n");
        this.right.toXCQLInternal(b, level + 2);
        b.indent(level + 1).append("</rightOperand>\n");
        CQLBooleanNode.renderSortKeys(b, level + 1, sortkeys);
        b.indent(level).append("</triple>\n");
    }

    @Override
    public String toCQL() {
        return "(" + this.left.toCQL() + ")" + " " + this.ms.toCQL() + " " + "(" + this.right.toCQL() + ")";
    }

    @Override
    public String toPQF(Properties config) throws PQFTranslationException {
        return "@" + this.opPQF() + " " + this.left.toPQF(config) + " " + this.right.toPQF(config);
    }

    String opPQF() {
        return this.ms.getBase();
    }

    @Override
    public byte[] toType1BER(Properties config) throws PQFTranslationException {
        System.out.println("in CQLBooleanNode.toType1BER(): PQF=" + this.toPQF(config));
        byte[] rpn1 = this.left.toType1BER(config);
        byte[] rpn2 = this.right.toType1BER(config);
        byte[] op = this.opType1();
        byte[] rpnStructure = new byte[rpn1.length + rpn2.length + op.length + 4];
        int offset = CQLBooleanNode.putTag(2, 1, 1, rpnStructure, 0);
        rpnStructure[offset++] = -128;
        System.arraycopy(rpn1, 0, rpnStructure, offset, rpn1.length);
        System.arraycopy(rpn2, 0, rpnStructure, offset += rpn1.length, rpn2.length);
        System.arraycopy(op, 0, rpnStructure, offset += rpn2.length, op.length);
        offset += op.length;
        rpnStructure[offset++] = 0;
        rpnStructure[offset++] = 0;
        return rpnStructure;
    }

    abstract byte[] opType1();
}

